#include <stdio.h>
#include "mem.h"

int main (int argc, char *argv[]) {
	unsigned long size, size1, base, last, contiguous;
	unsigned long M1  =  1UL * 1024UL;
	unsigned long M14 = 14UL * 1024UL;
	unsigned long M64 = 64UL * 1024UL;
	int rc = 0;
	unsigned char DA = 0, C7 = 0, E801 = 0, E820 = 0, MemHole = 0;
	static struct {
		unsigned long cont;
		unsigned long base;
		unsigned long base1;
		unsigned long len;
		unsigned long len1;
		unsigned long type;
	} desc;
	static struct {
		unsigned short size;
		unsigned long local, local16;
		unsigned long system, system16;
		unsigned long cacheable, cacheable16;
		unsigned long nonsys, nonsys16;
		unsigned short x1, x2;
		unsigned long res;
	} desc1;
	static struct {
		unsigned short cb;
		unsigned char  model;
		unsigned char  submodel;
		unsigned char  biosrev;
		unsigned char  feature[5];
		unsigned char  filler[6];
	} ROMConfig;

	size = Int12();
	printf ("Int12        returns: %ld KiBytes\n", size);
	if (Int15C0 (&ROMConfig)) ROMConfig.feature[1] = 0;
	size = Int1588();
	if (size == -1)
		printf ("Int15 (88)   returns: not supported\n");
	else
		printf ("Int15 (88)   returns: %ld KiBytes above 1MiB\n", size);
#if 0
	size = Int158A();
	if (size == -1)
		printf ("Int15 (8A)   returns: not supported\n");
	else
		printf ("Int15 (8A)   returns: %ld KiBytes above 1MiB\n", size);
#endif
	if (ROMConfig.feature[1] & 0x10) {
		size = Int15C7 (&desc1);
		desc1.local 		+= desc1.local16;
		desc1.system		+= desc1.system16;
		desc1.cacheable += desc1.cacheable16;
		desc1.nonsys		+= desc1.nonsys16;
		if (size == -1)
			printf ("Int15 (C7)   returns: not supported\n");
		else {
			printf ("Int15 (C7)   returns memory table:\n");
			printf ("  local  memory: %ld KiBytes above 1MiB\n", desc1.local);
			printf ("  system memory: %ld KiBytes above 1MiB\n", desc1.system);
			printf ("  cacheable mem: %ld KiBytes above 1MiB\n", desc1.cacheable);
			printf ("  address space: %ld KiBytes above 1MiB before non-system memory\n", desc1.nonsys);
			C7 = 1;
		}
	} else
		printf ("Int15 (C0)   returns: PS/2 function Int15 (C7) is not supported\n");
	size = Int15DA88();
	if (size == -1)
		printf ("Int15 (DA88) returns: not supported\n");
	else {
		printf ("Int15 (DA88) returns: %ld KiBytes above 1MiB\n", size);
		DA = size >= M64;
	}
	size = Int15E801(0);
	size1= Int15E801(1);
	if (size == -1) {
		printf ("Int15 (E801) returns: not supported\n");
		E801 = 1;
	} else {
		printf ("Int15 (E801) returns: %ld KiBytes above 1MiB available\n                      %ld KiBytes above 1MiB configured\n", size, size1);
		E801 = size <= M64;
	}
	if (size == M14)
		MemHole = 1;

	contiguous = 0;
	last = 0;
	printf ("Int15 (E820) returns memory list:\n");
	desc.cont = 0;
	do {
		Int15E820 (&desc);
		if (desc.type == 1) {
			size = desc.len  >> 10;
			base = desc.base >> 10;
			printf ("  %8lu KiBytes @ %lu K\n", size, base);
			E820 = 1;
			if ((base == M1) && (size == M14))
				MemHole = 1;
			if (base >= M1) {
				if (last) {
					if ((base != last) && (contiguous == 0))
						contiguous = last;
				}
				last = base + size;
			}
		}
	} while (desc.cont != 0);
	if (contiguous == (M14 + M1)) {
		MemHole = 1;
		contiguous = 0;
	}

#if 0
	size = Int15E881();
	if (size == -1)
		printf ("Int15 (E881) returns: not supported\n");
	else
		printf ("Int15 (E881) returns: %ld KiBytes above 1MiB\n", size);
#endif

	if (MemHole) {
		printf ("\nMemory hole at 15MiB is active - switch it off in BIOS!\n");
		rc = -1;
	} else if (contiguous != 0) {
		printf ("\nACPI memory table has holes, max. contiguous range is %ldKiBytes\n", contiguous);
		printf ("Try switching off ACPI in BIOS!\n");
		rc = -2;
	} else if (E801 && !C7) {
		if (E820) {
			printf ("\n\"PatchLDR E820\" recommended\n");
			rc = 1;
		} else if (DA) {
			printf ("\n\"PatchLDR DA88\" recommended\n");
			rc = 2;
		}
	} else {
		printf ("\nNo patch required\n");
	}
	return (rc);
}
