open(OLD, "<conf/httpd-std.conf") || die "Couldn't open httpd-std.conf";
open(NEW, ">conf/httpd-std.conf.fixed") || die "Couldn't open httpd-std.conf.fixed";

%stdmod = (
  "access_module" => 1,
  "auth_module" => 1,
  "include_module" => 1,
  "log_config_module" => 1,
  "env_module" => 1,
  "setenvif_module" => 1,
  "mime_module" => 1,
  "status_module" => 1,
  "autoindex_module" => 1,
  "asis_module" => 1,
  "cgi_module" => 1,
  "negotiation_module" => 1,
  "dir_module" => 1,
  "imap_module" => 1,
  "actions_module" => 1,
  "userdir_module" => 1,
  "alias_module" => 1
);


while (<OLD>) {
  if ( /^LoadModule (\w+) modules\/(\w+).so$/ ) {
    $symbol = $1;
    $modname = $2;
    $modname =~ s/^mod_//;
    $modname = substr($modname, 0, 8);
    if ( $stdmod{$symbol} ) {
      print NEW "LoadModule $symbol modules/$modname.dll\n";
    } else {
      print NEW "# LoadModule $symbol modules/$modname.dll\n";
    }
  } else {
    print NEW $_;
  }
}

close(OLD);
close(NEW);
unlink "conf/httpd-std.conf";
rename "conf/httpd-std.conf.fixed", "conf/httpd-std.conf";
