/* ====================================================================
 * Copyright (c) 1999 The Apache Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * 4. The names "Apache Server" and "Apache Group" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Group.
 * For more information on the Apache Group and the Apache HTTP server
 * project, please see <http://www.apache.org/>.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <sys/signal.h>
#include <ctype.h>
#include <string.h>

#define MAX_SIGNUM 21
char *signames[MAX_SIGNUM+1] = {
    "", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "EMT", "FPE", "KILL",
    "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "USR1", "USR2", "CHLD", "", "", "BREAK"
};

int main(int argc, char *argv[])
{
    long pid;
    int arg, signum=SIGTERM, rc=0;

    if (argc < 2) {
        fprintf(stderr, "Usage: kill [-SIG] pid [pid ...]\n"
                        "  where SIG is one of\n\t");
        for (signum=0; signum <= MAX_SIGNUM; signum++) {
            if (signames[signum][0])
                fprintf(stderr, "%s ", signames[signum]);
            if (signum == 10)
                fprintf(stderr, "\n\t");
        }
        fprintf(stderr, "\n");
        return 1;
    }

    for (arg=0; arg<argc; arg++) {
        if (argv[arg][0] == '-') {
            if (isdigit((int)argv[arg][1])) {
                signum = atoi(argv[arg] + 1);
            } else {
                for (signum = 0; signum<=MAX_SIGNUM; signum++)
                    if (stricmp(argv[arg] + 1, signames[signum]) == 0)
                        break;

                if (signum > MAX_SIGNUM) {
                    fprintf(stderr, "kill: invalid signal name '%s'\n", argv[arg] + 1);
                    return 1;
                }
            }
        } else {
            pid = atoi(argv[arg]);
            if (pid != 0) {
                rc = kill(pid, signum);
                if (rc) {
                    fprintf(stderr, "Error sending signal to %ld: %s\n", pid, strerror(errno));
                    break;
                }
            }
        }
    }

    return rc;
}
