/*
 * JBorder.cpp
 *
 * A border control, based on static things
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JBorder.hpp"
#include "JCoord.hpp"
#include "JControl.hpp"
#include "JWindow.hpp"
#include "JColour.hpp"
#include "JPaintH.hpp"
#include "JPSpace.hpp"
#include "JIntern.hpp"

// paint handler
class JBorderPaintHandler : public JPaintHandler
{
 public:
   JBorderPaintHandler() : JPaintHandler() {}
   BOOL paint( JPaintEvent &e)
   {
      JBorder *b = (JBorder *) e.window();
      b->paint( e.ps(), e.updateRect());
      return true; // handled event ok
   }
};

static JBorderPaintHandler _JLibBorderPH;

JBorder::JBorder( JWindow *parent, ulong id)
        : JControl( parent, id), drawtype( JBorder::normal), sizee( 1, 1)
{}

JBorder::JBorder( HWND hwnd)
        : JControl( hwnd), drawtype( JBorder::normal), sizee( 1, 1)
{}

JBorder::JBorder( JWindow *parent, const JPoint &position, const JSize &sz,
                  ulong ID) : JControl(), drawtype( JBorder::normal),
                              sizee( 1, 1)
{
   assertParms( parent, "JBorder::JBorder");

   JCreateWBlock b( parent->handle(), WC_STATIC, 0,
                    JWindow::visible | SS_FGNDFRAME, position, sz,
                    parent->handle(), HWND_TOP, ID, 0, 0);

   setHwnd( JInternal::window::create( &b));
}

JBorder &JBorder::setType( JBorder::type t)
{
   if( drawtype != t) {
      attach( &_JLibBorderPH); // who knows what happens if this gets called
      drawtype = t;            // more than once...
      invalidate();
   }
   return self;
}

JBorder &JBorder::setSize( const JSize &sz)
{
   sizee = sz;
   return self;
}

void JBorder::paint( JBPSpace &ps, JRect &)
{
   if( !drawtype)
      defaultAction( WM_PAINT); // !! this won't work...
   else {
      // don't care about clip-rect; just draw the border.
      JRect rect( 0, 0, size());

      if( !WinDrawBorder( ps.handle(), rect, sizee.x, sizee.y,
                          0, 0, drawtype))
          pmError( 4, "WinDrawBorder");
   }
}
