/*
 * JButton.cpp
 *
 * Base button control - sorta a.b.c, but not really.
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JButton.hpp"
#include "JCoord.hpp"
#include "JControl.hpp"
#include "JWindow.hpp"
#include "JCtlH.hpp"
#include "JIntern.hpp"

// this ctor is protected, so only descendant classes can call it.
JButton::JButton( JWindow *parent, const char *text, ulong style,
                  const JPoint &pos, const JSize &size, ulong Id) : JControl()
{
   assertParms( parent, "JButton::JButton");

   JCreateWBlock b( parent->handle(), WC_BUTTON, (char*)text,
                    JWindow::visible | style, pos, size, parent->handle(),
                    HWND_TOP, Id, 0, 0);

   setHwnd( JInternal::window::create( &b));
}

const unsigned long JButton::autosize = BS_AUTOSIZE;

JButton &JButton::click()
{
   sendEvent( BM_CLICK);
   return self;
}

BOOL JButton::event( const JCtlEvent &e)
{
   switch( e.notify()) {
      case BN_CLICKED:
         return mouseclick();
      case BN_DBLCLICKED:
         return doubleclick();
      default:
         return false;
   }
}
