/*
 * JCBox.cpp
 *
 * Combobox control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JCBox.hpp"
#include "JWindow.hpp"
#include "JCtlH.hpp"
#include "JListBox.hpp"
#include "JEntFld.hpp"
#include "JIntern.hpp"

const unsigned long JComboBox::simple     = CBS_SIMPLE;
const unsigned long JComboBox::dropdown   = CBS_DROPDOWN;
const unsigned long JComboBox::dropdownRO = CBS_DROPDOWNLIST;
const unsigned long JComboBox::normal     = CBS_DROPDOWNLIST;
const unsigned long JComboBox::autotab    = ES_AUTOTAB;
const unsigned long JComboBox::horzScroll = LS_HORZSCROLL;

JComboBox::JComboBox( ulong hwnd) : JListBox( hwnd)
{
   getChilder();
}

JComboBox::JComboBox( JWindow *w, ulong id) : JListBox( w, id)
{
   getChilder();
}

JComboBox::JComboBox( JWindow *w, const JPoint &pos, const JSize &size,
                      ulong Id, ulong style) : JListBox()
{
   assertParms( w, "JComboBox::JComboBox");
   JCreateWBlock b( w->handle(), WC_COMBOBOX, 0, JWindow::visible | style,
                    pos, size, w->handle(), HWND_TOP, Id, 0, 0);

   setHwnd( JInternal::window::create( &b));

   getChilder();
}

// get objects for child component thingies
void JComboBox::getChilder()
{
   // well, the combobox control, in dropdown mode, only appears to create
   // its listbox when you click the li'l button - when the listbox closes,
   // it gets destroyed again. This makes life hell in general; essentially
   // we can't maintain a masking listbox object. So we take advantage of the
   // fact that the combobox seems to process most of the listbox messages
   // without too many hassles, and do this...
   ef = new JEntryField( this, CBID_EDIT);
   if( WinWindowFromID( handle(), CBID_LIST))
      lb = new JListBox( this, CBID_LIST);
   else
      lb = this;
}

JComboBox::~JComboBox()
{
   delete ef;
   if( lb != this) // rather important test :->
      delete lb;
}

BOOL JComboBox::isListShowing() const
{
   return sendEvent( CBM_ISLISTSHOWING);
}

JComboBox &JComboBox::showList( BOOL show)
{
   sendEvent( CBM_SHOWLIST, show);
   return self;
}

JComboBox &JComboBox::hilight( BOOL yes)
{
   sendEvent( CBM_HILITE, yes);
   return self;
}

BOOL JComboBox::event( const JCtlEvent &e)
{
   switch( e.notify()) {
      case CBN_EFCHANGE:
         return changed();
      case CBN_EFSCROLL:
         return efScrolled();
      case CBN_LBSELECT:
      {
         JListBox::cursor c( lb);
         return selected( c);
         break;
      }
      case CBN_LBSCROLL:
         return lbScrolled();
      case CBN_SHOWLIST:
         return dropDown();
      case CBN_ENTER:
      {
         JListBox::cursor c( lb);
         return choice( c);
         break;
      }
   }
   return false;
}
