/*
 * JCanvas.cpp
 *
 * Base drawing canvas
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */


#define _jlib_err
#include "Jos2.h"
#include "JDC.hpp"
#include "JCanvas.hpp"
#include "JWindow.hpp"
#include "JControl.hpp"
#include "JCoord.hpp"
#include "JPaintH.hpp"
#include "JIntern.hpp"

#include "JBitmap.hpp"
#include "JPSpace.hpp"
#include "JGPrim.hpp"

const ulong JCanvas::sizeRedraw = 0x01;

JCanvas::JCanvas( JWindow *parent, const JPoint &pos,
                  const JSize &size, ulong Id, ulong style)
        : JControl(), JPaintHandler( true)
{
   assertParms( parent, "JCanvas::JCanvas");

   JCreateWBlock b( parent->handle(),
                    ( (style & JCanvas::sizeRedraw) ?
                      JInternal::window::SRName()   :
                      JInternal::window::name()    ), 0,
                    JWindow::visible | style, pos, size, parent->handle(),
                    HWND_TOP, Id, 0, 0);

   setHwnd( JInternal::window::create( &b));

   attach( this);
}

JCanvas::JCanvas( JWindow *parent, ulong Id) : JControl()
{
   assertParms( parent, "JCanvas::JCanvas");

   // find out about the guy we're gonna replace
   JWindow *ctrl = parent->childWithID( Id);
   JSize sz = ctrl->size();
   JPoint wh = ctrl->origin();
   // then grease him
   ctrl->destroy();

   // and insert ourselves as replacement

   JCreateWBlock b( parent->handle(), JInternal::window::name(), 0,
                    JWindow::visible, wh, sz, parent->handle(),
                    HWND_TOP, Id, 0, 0);

   setHwnd( JInternal::window::create( &b));

   attach( this);
}

// Buffered canvas ------------------------------------------------------------
JBufferedCanvas::JBufferedCanvas( const JSize &pelSize, ulong bpp,
                                  JWindow *parent, const JPoint &pos,
                                  const JSize &size, ulong id, ulong style)
                : JCanvas( parent, pos, size, id, style)
{
   setup( pelSize, bpp);
}

JBufferedCanvas::JBufferedCanvas( const JSize &pelSize, ulong bpp,
                                  JWindow *parent, ulong id)
               : JCanvas( parent, id)
{
   setup( pelSize, bpp);
}

void JBufferedCanvas::setup( const JSize &pelSz, ulong bpp)
{
   _dc = new JMemoryDC;
   _ps = new JPSpace( *_dc);
   _bmp = new JBitmap( pelSz, bpp);
   _ps->select( *_bmp);
}

BOOL JBufferedCanvas::paint( JPaintEvent &e)
{
   e.ps().render( JBmpImage( *_ps, e.updateRect(), e.updateRect()));
   return true;
}

JBufferedCanvas::~JBufferedCanvas()
{
   _ps->deselectBitmap();
   delete _bmp;
   delete _ps;
   delete _dc;
}

void JBufferedCanvas::setNewBitmapSize( const JSize &pelSize)
{
   ulong bpp = _bmp->bpp();
   _ps->deselectBitmap();
   delete _bmp;
   _bmp = new JBitmap( pelSize, bpp);
   _ps->select( *_bmp);
}
