/*
 * JCnrH.cpp
 *
 * Container messages handlers
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JCnrH.hpp"
#include "JEvent.hpp"
#include "JCnr.hpp"
#include "JCnrRec.hpp"
#include "JDragSet.hpp"
#include "JDrgItem.hpp"

#include "JKeyH.hpp"

#include "jtrace.hpp"
#include "Jsystem.hpp"

// a fair amount of code here is duplicated with JDragHandler; so sue me.
BOOL JCnrHandler::handle( JEventData *e)
{
   JContainer *cnr = (JContainer *) e->win;
   switch( e->msg) {
      case WM_CLOSE:
         return destroy( cnr);
      case WM_MENUEND:
         return menuEnd( cnr);
      case DM_ENDCONVERSATION:
      {
         BOOL success = true;
         if( e->mp2 == DMFL_TARGETFAIL) success = false;

         // hmm: if the op was a shred, then this record doesn't
         // exist any more...
         cnr->dragEnded( (JCnrRecord *) e->mp1(),
                         (JDrag::operation) cnr->currentOp, success);

         // time to free the draginfo ?
         // !! should check lazy count first !!
         if( JDrag::Info.cDragitems > 0) {
            if( !--JDrag::Info.cDragitems) {
               // this free corresponds to the DrgDrag allocate
               // (ought to assert we're the source)
               DrgFreeDraginfo( (PDRAGINFO) JDrag::Info.pDraginfo);
               JDrag::Info.pDraginfo = 0;
            }
         }

         trace << "endconv";

         return true;
      }
      case DM_DROPNOTIFY: // lazy drags
         return dropNotify( cnr, e->mp2, e->mp1);
      case DM_DRAGOVERNOTIFY:
      {
         // we use these to track what the current operation is
         if( (JDrag::dropState) e->mp2.s1() == JDrag::yes)
            cnr->currentOp = e->mp2.s2();

         return true;
      }
      case DM_DISCARDOBJECT:
      {
         JDragSet   set( e->mp1());
         JDrag::psr p;
         int        i, j( set.items());

         trace << "discard";

         for( i = 0; i < j; i++)
            p = cnr->deleteRecord( ((JCnrRecord *) set[ i].itemID()));

         // hmm; oh well.
         e->rc = p;

         return true;
      }
      case DM_PRINTOBJECT:
      {
         JDragItem  item( e->mp1());
         JDrag::psr p;

         trace << "Print";

         e->rc = ((JCnrRecord*)item.itemID())->print( e->mp2);
         return true;
      }
   }
   return false;
}

BOOL JCnrHandler::destroy( JContainer *cnr)
{
   // first free up any memory we alloc'ed for the title
   CNRINFO cnrInfo;
   cnr->getInfo( &cnrInfo);
   if( cnrInfo.pszCnrTitle)
      free( cnrInfo.pszCnrTitle);

   // get rid of all the objects which've been put into us
   cnr->empty( true);

   // get rid of any columns
   JCnrColumnList list;
   JCnrColumnList::cursor c( cnr->allColumns( list));
   for_cursor( c)
      (*c.current())->remove( true);

   // continue with normal close-action processing
   return false;
}

BOOL JCnrHandler::menuEnd( JContainer *cnr)
{
   // an open menu was closed. So we get rid of the source emphasis.
   JCnrRecordList l;
   cnr->sourcedRecords( l);
   if( l.elements() ) {
      JCnrRecordList::cursor c( l);
      for_cursor( c)
         (*c.current())->removeEmphasis( JCnr::sourced);
   } else
      cnr->setSource( false);
   return true;
}

// callback for lazy drags
BOOL JCnrHandler::dropNotify( JContainer *cnr, ulong hwnd, void *draginfo)
{
   // get rid of the picked emphasis
   JCnrRecordList l;
   cnr->pickedRecords( l);

   JCnrRecordList::cursor c( l);

   for_cursor( c)
      (*c.current())->removeEmphasis( JCnr::picked);

   // if hwnd =0 then drop was canceled; if this happened, or the target wnd
   // isn't the src wnd, then free the draginfo.
   if( !hwnd || hwnd != cnr->handle())
      DrgFreeDraginfo( (PDRAGINFO) draginfo);

   return true;
}

// the keypress handler; for the delete button.
BOOL JCnrKeyHandler::keypress( const JKeyEvent &e)
{
   JContainer *cnr = (JContainer *) e.window();
   if( e.isVk() && !e.isKeyUp() && e.vk() == JKeyEvent::del) {
      JCnrRecordList l;
      cnr->selectedRecords( l);

      JCnrRecordList::cursor c( l);

      for_cursor( c)
         if( JDrag::abort == cnr->deleteRecord( *c.current())) break;

      return true;
   }
   return false;
}
