/*
 * JCnrODH.cpp
 *
 * Owner-draw handlers & events for the container control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JCnrODH.hpp"
#include "JCnr.hpp"
#include "JCnr2.hpp"

#include "JPSpace.hpp"

#define objFromRc( s) ( (JCnrRecord *) (((char *)s) + sizeof( MINIRECORDCORE)))

// cm_paintbackground handling routines --------------------------------------
JBPSpace JCnrPaintEvent::ps() const
{
   return JBPSpace( ((POWNERBACKGROUND) e->mp1())->hps) ;
}

JRect JCnrPaintEvent::updateRect() const
{
   return JRect( ((POWNERBACKGROUND) e->mp1())->rclBackground);
}

JContainer *JCnrPaintEvent::cnr()
{
   return (JContainer *) e->win;
}

// handler
BOOL JCnrPaintHandler::handle( JEventData *e)
{
   if( e->msg == CM_PAINTBACKGROUND) {
      JCnrPaintEvent ev( e);
      return paintBackground( ev);
   }
   return false;
}

// owner draw bits -----------------------------------------------------------
JContainer *JCnrDrawEvent::cnr()
{
   return (JContainer *) e->window()->childWithID( e->controlID());
}

// record drawing
JCnrRecord *JCnrRecordDrawEvent::record()
{
   PCNRDRAWITEMINFO pThing = (PCNRDRAWITEMINFO) e->itemHandle();
   return cnr()->initialise( objFromRc( pThing->pRecord));
}

// column drawing
JCnrColumn *JCnrColumnDrawEvent::column() const
{
   PCNRDRAWITEMINFO pThing = (PCNRDRAWITEMINFO) e->itemHandle();
   JFieldInfo *fl = (JFieldInfo *) pThing->pFieldInfo;
   return fl->me;
}

// column record drawing
// handler
BOOL JCnrObjectPaintHandler::drawItem( const JDrawItemEvent &e)
{
   JDrawItemEvent &ev = (JDrawItemEvent &) e;
   switch( ev.itemID()) {
      case CMA_CNRTITLE:
      {
         JCnrDrawEvent e( ev);
         return drawCnrTitle( e);
      }
      case 0:
      {
         // details; if there's no rec, draw the title
         if( !((PCNRDRAWITEMINFO) ev.itemHandle())->pRecord) {
            JCnrColumnDrawEvent e( ev);
            return drawColumnTitle( e);
         } else {
            JCnrColRecDrawEvent e( ev);
            return drawColumn( e);
         }
      }
      default:
      {
         JCnrRecordDrawEvent e( ev);
         switch( ev.itemID()) {
            case CMA_ICON:
               return drawRecordGraphic( e);
            case CMA_TEXT:
               return drawRecordText( e);
            case CMA_TREEICON:
               return drawTreeIcon( e);
         }
      }
   }
   return false;
}
