/*
 * JColour.cpp
 *
 * Miscellaneous things to do with colours in general
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JColour.hpp"
#include "JWindow.hpp"
#include <string.h>

JColour::JColour( char r, char g, char b) : bBlue( b), bGreen( g), bRed( r), dummy( 0)
{}

JColour::JColour( ulong dword) : dummy( 0)
{
   PRGB2 prgb2 = (PRGB2) &dword;
   bGreen = prgb2->bGreen;
   bBlue = prgb2->bBlue;
   bRed = prgb2->bRed;
}

JColour JColour::system( short ndx)
{
   long rgb = WinQuerySysColor( JWindow::theDesktopWindow, ndx, 0);
   return JColour( rgb);
}

JColour::operator _RGB2 * () const
{ return (PRGB2) this; }

JColour::operator _RGB2 & () const
{ return (RGB2 &) self; }

// system colours -------------------------------------------------------------
const JColour JColour::shadowHilightBackground( JColour::system( -50));
const JColour JColour::shadowHilightForeground( JColour::system( -49));
const JColour JColour::shadowText( JColour::system( -48));
const JColour JColour::entryfield( JColour::system( -47));
const JColour JColour::menuDisabledText( JColour::system( -46));
const JColour JColour::menuHilight( JColour::system( -45));
const JColour JColour::menuHilightBackground( JColour::system( -44));
const JColour JColour::pageBackground( JColour::system( -43));
const JColour JColour::controlBackground( JColour::system( -42));
const JColour JColour::lightButton( JColour::system( -41));
const JColour JColour::middleButton( JColour::system( -40));
const JColour JColour::darkButton( JColour::system( -39));
const JColour JColour::defaultButton( JColour::system( -38));
const JColour JColour::titlebarBottom( JColour::system( -37));
const JColour JColour::shadow( JColour::system( -36));
const JColour JColour::iconText( JColour::system( -35));
const JColour JColour::dialogBackground( JColour::system( -34));
const JColour JColour::hilightForeground( JColour::system( -33));
const JColour JColour::hilightBackground( JColour::system( -32));
const JColour JColour::inactiveTitleBackground( JColour::system( -31));
const JColour JColour::activeTitleBackground( JColour::system( -30));
const JColour JColour::inactiveTitleText( JColour::system( -29));
const JColour JColour::activeTitleText( JColour::system( -28));
const JColour JColour::outputText( JColour::system( -27));
const JColour JColour::staticText( JColour::system( -26));
const JColour JColour::scrollbar( JColour::system( -25));
const JColour JColour::desktopBackground( JColour::system( -24));
const JColour JColour::activeTitlebar( JColour::system( -23));
const JColour JColour::inactiveTitlebar( JColour::system( -22));
const JColour JColour::menuBackground( JColour::system( -21));
const JColour JColour::windowBackground( JColour::system( -20));
const JColour JColour::windowFrame( JColour::system( -19));
const JColour JColour::menuText( JColour::system( -18));
const JColour JColour::windowText( JColour::system( -17));
const JColour JColour::titleText( JColour::system( -16));
const JColour JColour::activeBorder( JColour::system( -15));
const JColour JColour::inactiveBorder( JColour::system( -14));
const JColour JColour::windowBackground2( JColour::system( -13));
const JColour JColour::helpBackground( JColour::system( -12));
const JColour JColour::helpText( JColour::system( -11));
const JColour JColour::helpHilight( JColour::system( -10));

// Real colours ---------------------------------------------------------------
const JColour JColour::white( 255, 255, 255);
const JColour JColour::black( 0, 0, 0);
const JColour JColour::blue( 0, 0, 255);
const JColour JColour::red( 255, 0, 0);
const JColour JColour::pink( 255, 0, 255);
const JColour JColour::green( 0, 255, 0);
const JColour JColour::cyan( 0, 255, 255);
const JColour JColour::yellow( 255, 255, 0);
const JColour JColour::pale_grey( 204, 204, 204);
const JColour JColour::dark_grey( 128, 128, 128);
const JColour JColour::dark_blue( 0, 0, 128);
const JColour JColour::dark_red( 128, 0, 0);
const JColour JColour::dark_pink( 128, 0, 128);
const JColour JColour::dark_green( 0, 128, 0);
const JColour JColour::dark_cyan( 0, 128, 128);
const JColour JColour::brown( 128, 128, 0);
