/*
 * JCoord.cpp
 *
 * Coordinate classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JCoord.hpp"

// vector-geometry thingies ---------------------------------------------------
double JOrderedPair::angleBetween( const JOrderedPair &op2) const
{
   double denom = magnitude() * op2.magnitude();
   if( !denom) return 0;
   return acos( dot( op2) / denom);
}

double JOrderedPair::projectionOnto( const JOrderedPair &op2) const
{
   double d = op2.magnitude();
   if( !d) return 0;
   return this->dot( op2) / op2.magnitude();
}

// PM things ------------------------------------------------------------------
JOrderedPair::operator _POINTL *() const
{ return (PPOINTL) this; }

JOrderedPair::operator _POINTL &() const
{ return (POINTL &) self; }

// Static constant things -----------------------------------------------------
const JSize _autosize( -1, -1);

// Rectangle class -----------------------------------------------------------
JRect::JRect( const RECTL &r) : min( r.xLeft, r.yBottom),
                                max( r.xRight, r.yTop)
{}

// Containment & intersection ------------------------------------------------
BOOL JRect::intersects( JRect &r) const
{
   return contains( r.min) ||
          contains( r.topLeft()) ||
          contains( r.max) ||
          contains( r.bottomRight()) ||
          r.contains( min) ||
          r.contains( JPoint( min.x, max.y)) ||
          r.contains( max) ||
          r.contains( JPoint( max.x, min.y));
}

BOOL JRect::contains( const JRect &r) const
{
   return contains( r.bottomLeft()) &&
          contains( r.topLeft()) &&
          contains( r.topRight()) &&
          contains( r.bottomRight());
}

BOOL JRect::contains( const JPoint &p) const
{
   return p.x <= max.x && p.x >= min.x &&
          p.y >= min.y && p.y <= max.y;
}

// PM Stuff ------------------------------------------------------------------
JRect::operator _RECTL * () const
{ return (PRECTL) this; }

JRect::operator _RECTL & () const
{ return (RECTL &) self; }
