/*
 * JCstLBox.cpp
 *
 * Custom Listbox control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JCstLBox.hpp"
#include "JListbox.hpp"
#include "JControl.hpp"
#include "JWindow.hpp"
#include "JCoord.hpp"
#include "JOwnerDH.hpp"
#include "JPSpace.hpp"

#define lbError( s) jlib_throw( new JException( err_lbox1, JExn::base, s))

// adoption occurs, so this handler needs to be attached to the listbox
class LBoxDrawer : public JOwnerDrawHandler
{
 public:
   LBoxDrawer() : JOwnerDrawHandler() {}

   BOOL measureItem( const JMeasureEvent &e)
   {
      JCustomLBox *lb = (JCustomLBox *) e.window();
      JMR rc( lb->itemHeight(), lb->itemWidth());
      e.setrc( rc);
      return true;
   }

   BOOL drawItem( const JDrawItemEvent &e)
   {
      JCustomLBox *lb = (JCustomLBox *) e.window();

      // Set up the item
      JListBox::item itm( lb, e.itemID());
      JRect          rcl = e.itemRect();

      lb->drawItem( itm, e.ps(), rcl, e.state());
      e.state() = e.oldState() = 0;
      e.setrc( true);

      return true;
   }
};

static LBoxDrawer lboxdrawer;

void JCustomLBox::setup( JWindow *w)
{
   w->adopt( this);
   attach( &lboxdrawer);

   setItemHeight( itemSize.y);

   if( hasStyle( JListBox::horzScroll))
      setItemWidth( itemSize.x);
   else
      setItemWidth( 0);
}

JCustomLBox::JCustomLBox( JWindow *w, ulong Id, const JSize &s)
            : JListBox( w, Id), itemSize( s)
{
   setup( w);
}

JCustomLBox::JCustomLBox( JWindow *parent, const JPoint &pos,
                          const JSize &size, ulong id, const JSize &itemsize,
                          ulong style)
            : JListBox( parent, pos, size, id, style | LS_OWNERDRAW),
              itemSize( itemsize)
{
   setup( parent);
}

JCustomLBox &JCustomLBox::setItemHeight( short y)
{
   itemSize.y = y;

   if( y) {
      BOOL rc = sendEvent( LM_SETITEMHEIGHT, y);
      if( !rc)
         lbError( "set the item height");
   }
   return self;
}

JCustomLBox &JCustomLBox::setItemWidth( short x)
{
   itemSize.x = x;

   if( x) {
      BOOL rc = sendEvent( LM_SETITEMWIDTH, x);
      if( !rc)
         lbError( "set the item width");
   }
   return self;
}
