/*
 * JCusButt.cpp
 *
 * Custom button control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JCusButt.hpp"
#include "JCoord.hpp"
#include "JButton.hpp"
#include "JCtlH.hpp"
#include "JPSpace.hpp"

JCustomButton::JCustomButton( JWindow *parent, const JPoint &pos,
                              const JSize &size, ulong id,
                              ulong style)
              : JPushButton( parent, pos, size, id, style | BS_USERBUTTON, "")
{}

BOOL JCustomButton::event( const JCtlEvent &e)
{
   if( e.notify() == BN_PAINT) {
      PUSERBUTTON p;
      JRect       wrect( 0, 0, size());

      p = (PUSERBUTTON) e.data();
      e.setrc( true);
      JBPSpace ps( p->hps);
      return paint( ps, wrect, (JCustomButton::ptype) p->fsState);
   }
   else
      return JButton::event( e);
}
