/*
 * JDC.cpp
 *
 * Device context classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "JOs2.h"
#include "JDC.hpp"
#include "JPM.hpp"
#include "JWindow.hpp"

ulong JDeviceContext::close()
{
   ulong rc = 0;
   if( hdc) {
      if( DEV_ERROR == ( rc = DevCloseDC( hdc)))
         pmError( 2, "DevCloseDC");
   }
   return rc;
}

// Properties -----------------------------------------------------------------
static ulong qc( ulong hdc, ulong v)
{
   long val = 0;
   BOOL rc = DevQueryCaps( hdc, v, 1, &val);
   if( !rc)
      pmError( 3, "DevQueryCaps");
   return val;
}

JDeviceContext::sort JDeviceContext::type() const
{ return (JDeviceContext::sort) qc( hdc, CAPS_TECHNOLOGY); }

ulong JDeviceContext::version() const
{ return qc( hdc, CAPS_DRIVER_VERSION); }

JSize JDeviceContext::size( BOOL inChars) const
{
   return JSize( inChars ? CAPS_WIDTH_IN_CHARS : CAPS_WIDTH,
                 inChars ? CAPS_HEIGHT_IN_CHARS : CAPS_HEIGHT);
}

ulong JDeviceContext::horzRes() const
{ return qc( hdc, CAPS_HORIZONTAL_RESOLUTION); }

ulong JDeviceContext::vertRes() const
{ return qc( hdc, CAPS_VERTICAL_RESOLUTION); }

ulong JDeviceContext::colours() const
{ return qc( hdc, CAPS_COLORS); }

ulong JDeviceContext::colourPlanes() const
{ return qc( hdc, CAPS_COLOR_PLANES); }

ulong JDeviceContext::colourDepth() const
{ return qc( hdc, CAPS_COLOR_BITCOUNT); }

ulong JDeviceContext::horzFontRes() const
{ return qc( hdc, CAPS_HORIZONTAL_FONT_RES); }

ulong JDeviceContext::vertFontRes() const
{ return qc( hdc, CAPS_VERTICAL_FONT_RES); }

BOOL JDeviceContext::supportsTransparency() const
{ return qc( hdc, CAPS_BACKGROUND_MIX_SUPPORT) & CAPS_BM_DESTTRANSPARENT; }

JReadOnlyDC::JReadOnlyDC( ulong w) : JDeviceContext()
{
   assertParms( w, "JReadOnlyDC::");
   hdc = w;
}

// --

JWindowDC::JWindowDC( JWindow *w) : JDeviceContext()
{
   hdc = WinOpenWindowDC( w->handle());
   if( !hdc) {
      hdc = WinQueryWindowDC( w->handle());
      if( !hdc)
         pmError( 2, "WinOpenWindowDC");
   }
}

// --

JMemoryDC::JMemoryDC() : JDeviceContext()
{
   DEVOPENSTRUC dop = { NULL, "DISPLAY", NULL, NULL, NULL };
   hdc = DevOpenDC( JPM::current()->hab(), OD_MEMORY, "*", 5,
                    (PDEVOPENDATA) &dop, 0);
   if( !hdc)
      pmError( 1, "DevOpenDC");
}

// --

JMetafileDC::JMetafileDC() : JDeviceContext()
{
   DEVOPENSTRUC dop = { NULL, "DISPLAY", NULL, NULL, NULL };
   hdc = DevOpenDC( JPM::current()->hab(), OD_METAFILE, "*", 2,
                    (PDEVOPENDATA) &dop, 0);
   if( !hdc)
      pmError( 1, "DevOpenDC");
}
