/*
 * JDialog.cpp
 *
 * Dialogs loaded from a resource file
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JDialog.hpp"
#include "JWindow.hpp"
#include "JModule.hpp"
#include "JMother.hpp"
#include "JResID.hpp"
#include "JIntern.hpp"
#include "JSystem.hpp"
#include "JFrame.hpp"

JDialog::JDialog( JWindow *owner, JResID id, JWindow *parent,
                  const JModule &md) : JMother( true)
{

   JCreateDlg cdlg( owner ? owner->handle() : 0, parent->handle(), md, id);
   HWND hwnd = JInternal::dialog::createDlg( cdlg);

   if( !hwnd)
      resError( "dialog");

   setHwnd( hwnd);
   setautodelete();
   subclass();
}

JDialog::JDialog( JResID id, JWindow *parent, const JModule &md) : JMother( 1)
{
   HWND hwnd = WinLoadDlg( parent->handle(),
                           0,
                           WinDefDlgProc,
                           md, id, NULL);
   if( !hwnd)
      resError( "dialog");

   setHwnd( hwnd);
   setautodelete();
   subclass();
}

const ulong JDialog::idCancel = DID_CANCEL;

ulong JDialog::showModally( BOOL sys) const
{
   if( sys) {
      BOOL rc = WinSetSysModalWindow( JWindow::theDesktopWindow, self);
      if( !rc)
         pmError( 2, "WinSetSysModalWindow");
   }
   ulong res = JInternal::dialog::process( handle());
   if( sys) {
      BOOL rc = WinSetSysModalWindow( JWindow::theDesktopWindow, 0);
      if( !rc)
         pmError( 1, "WinSetSysModalWindow");
   }
   return res;
}

void JDialog::dismiss( ulong value)
{
   BOOL rc = WinDismissDlg( handle(), value);
   if( !rc)
      pmError( 3, "WinDismissDlg");
}

JPoint &JDialog::mapPoint( JPoint &ptDlg)
{
   BOOL rc = WinMapDlgPoints( handle(), ptDlg, 1, true);
   if( !rc)
      pmError( 2, "WinMapDlgPoints");
   return ptDlg;
}
