/*
 * JDlgbar.cpp
 *
 * A dialog as a frame control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JDlgbar.hpp"
#include "JSWP.hpp"
#include "JCoord.hpp"
#include "JFrame.hpp"
#include "JColour.hpp"
#include "JBorder.hpp"
#include "JKeyH.hpp"

// what the feck is this about ??
class JDlgbarKeyhandler : public JKeyHandler
{
 public:
   JDlgbarKeyhandler() : JKeyHandler() {}
   BOOL keypress( const JKeyEvent &e)
   {
      JWindow *parent = e.window()->parent();
      JMR rc = parent->sendEvent( e);
      e.setrc( rc);
      return rc;
   }
};

static JDlgbarKeyhandler dlgbarkeyhandler;

const ulong JDialogBar::idDlgbar = 12;

JDialogBar::JDialogBar( JDialog *dlg) : JFrameCtl( JDialogBar::idDlgbar)
{
   // set up the dialog box
   ctl = dlg;
   ctl->setID( JDialogBar::idDlgbar);
   // this appears not to work...
   ctl->setStyle( JFrame::noByteAlign);
   // make sure keystrokes get processed properly
   ctl->attach( &dlgbarkeyhandler);
   // create a border control to bevel the dlg out
   brdr = new JBorder( ctl, JPoint( 0, 0), JSize( ctl->size()), 0);
   brdr->setType( JBorder::bevelOut);
   // move the border under the other controls
   brdr->toBottom();
}

JDialogBar::~JDialogBar()
{
   delete brdr;
}

void JDialogBar::format( JSWPArray &swps, JSWP &mySwp, JFrame *f)
{
   JFrameCtl::format( swps, mySwp, f);

   // resize the border if necessary
   if( mySwp.width() > brdr->size().y)
      brdr->resize( mySwp.size());
}
