/*
 * JDrag.cpp
 *
 * Dragndrop enumerations, static functions, etc.
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JDrag.hpp"
#include "JWindow.hpp"
#include <string.h>

// supported ops -------------------------------------------------------------
const ushort JDrag::copyable   = 1;
const ushort JDrag::moveable   = 2;
const ushort JDrag::linkable   = 4;
const ushort JDrag::createable = 8;

// static functions ----------------------------------------------------------
JPoint JDrag::lazyDrop( JWindow *target, JDrag::operation o)
{
   JPoint loc;
   BOOL rc = DrgLazyDrop( target->handle(), (ushort) o, loc);
   if( !rc)
      pmError( 2, "DrgLazyDrop");
   return loc;
}

void JDrag::cancelLazyDrag()
{
   BOOL rc = DrgCancelLazyDrag();
   if( !rc)
      pmError( 3, "DrgCancelLazyDrag");
}

JDrag::dtype JDrag::currentDrag()
{
   ulong rc = DrgQueryDragStatus();
   switch( rc) {
      case 0:
         return JDrag::noDrag;
      case DGS_DRAGINPROGRESS:
         return JDrag::drag;
      case DGS_LAZYDRAGINPROGRESS:
         return JDrag::lazyDrag;
   }
   return (JDrag::dtype) 0; // !!
}

// rm/rf/rmf classes ---------------------------------------------------------
JDrag::rm::rm( const JDrag::rm &copy)
{ mech = strdup( copy.value()); }

JDrag::rm::rm( char *s)
{ mech = strdup( s); }

JDrag::rm::~rm()
{ free( mech); }

char *JDrag::rm::value() const
{ return mech; }

const JDrag::rm JDrag::file( "DRM_OS2FILE");
const JDrag::rm JDrag::print( "DRM_PRINT");
const JDrag::rm JDrag::discard( "DRM_DISCARD");

JDrag::rf::rf( const JDrag::rf &copy)
{ fmt = strdup( copy.value()); }

JDrag::rf::rf( char *s)
{ fmt = strdup( s); }

JDrag::rf::~rf()
{ free( fmt); }

char *JDrag::rf::value() const
{ return fmt; }

const JDrag::rf JDrag::bitmap( "DRF_BITMAP");
const JDrag::rf JDrag::metafile( "DRF_METAFILE");
const JDrag::rf JDrag::rtf( "DRF_RTF");
const JDrag::rf JDrag::text( "DRF_TEXT");
const JDrag::rf JDrag::unknown( "DRF_UNKNOWN");

JDrag::rmf::rmf( const JDrag::rmf &copy)
{
   m = strdup( copy.RM());
   f = strdup( copy.RF());
}

JDrag::rmf::rmf( const JDrag::rm &mech, const JDrag::rf &format)
{
   m = strdup( mech.value());
   f = strdup( format.value());
}

JDrag::rmf::~rmf()
{ free( m); free( f); }

JDrag::rmf &JDrag::rmf::add( const JDrag::rm &mech)
{
   JVStr str( "%s,%s", m, mech.value());
   free( m);
   m = strdup( str.buffer());
   return self;
}

JDrag::rmf &JDrag::rmf::add( const JDrag::rf &fmt)
{
   JVStr str( "%s,%s", f, fmt.value());
   free( f);
   f = strdup( str.buffer());
   return self;
}

JStr JDrag::rmf::value() const
{
   return JVStr( "(%s) x (%s)", m, f);
}

// type class ------- really ought to template these single string classes ---
JDrag::type::type( const JDrag::type &copy)
{ t = strdup( copy.value()); }

JDrag::type::type( char *s)
{ t = strdup( s); }

JDrag::type::~type()
{ free( t); }

const JDrag::type JDrag::t_text( DRT_TEXT);
const JDrag::type JDrag::t_binary( DRT_BINDATA);
const JDrag::type JDrag::t_unknown( DRT_UNKNOWN);

// JDropOk class -------------------------------------------------------------
JDropOk::JDropOk( JDrag::dropState d, JDrag::operation o) : state( d), op( o)
{}

JDropOk::JDropOk() : state( JDrag::never), op( JDrag::def)
{}

JDrag::draginfo JDrag::Info;
