/*
 * JDragH.cpp
 *
 * Source drag handlers
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JDragH.hpp"
#include "JDrag.hpp"
#include "JDrgItem.hpp"
#include "JEvent.hpp"
#include "JWindow.hpp"

#include "JTrace.hpp"

// Standard drag events and handler ------------------------------------------
// Dragend event
BOOL JDragEndEvent::targetOK() const
{
   return ((ulong) e->mp2) & DMFL_TARGETSUCCESSFUL;
}

// Handler
BOOL JDragHandler::handle( JEventData *e)
{
   switch( e->msg) {
      case WM_BEGINDRAG:
      {
         JDragItem *itm = beginDrag( JBeginDragEvent( e, false));
         if( itm) {
            JStdDragSet dragset( e->win, 1);
            dragset.addDragItem( *itm);
            delete itm;
            dragset.drag();
            return true;
         }
         return false;
      }
      case WM_PICKUP:
      {
         JDragItem *itm = beginDrag( JBeginDragEvent( e, true));
         if( itm) {
            JLazyDragSet dragset( e->win);
            dragset.addDragItem( *itm);
            delete itm;
            dragset.lazyDrag();
            return true;
         }
         return false;
      }
      case DM_ENDCONVERSATION:
      {
         BOOL rc = dragEnded( JDragEndEvent( e, (ushort) lastOp));

         // time to free the draginfo ?
         // !! should check lazy count first !!
         if( JDrag::Info.cDragitems > 0) {
            if( !--JDrag::Info.cDragitems) {
               // this free corresponds to the DrgDrag allocate above
               // (ought to assert we're the source)
               DrgFreeDraginfo( (PDRAGINFO) JDrag::Info.pDraginfo);
               JDrag::Info.pDraginfo = 0;
            }
         }

         return rc;
      }
      case DM_DRAGOVERNOTIFY:
         // we use this msg to track what the current operation actually is.
         // I hate this, 'cos we should get told when the drag ends. Doh.
         if( (JDrag::dropState) e->mp2.s1() == JDrag::yes)
            lastOp = e->mp2.s2();
         return true;
      case DM_DROPNOTIFY: // nb this is just for lazy-drags
      {
         ulong hwnd = e->mp2;
         if( hwnd == e->win->handle() || !hwnd)
            DrgFreeDraginfo( (PDRAGINFO) (( void *) e->mp1));
         return true;
      }
   }
   return false;
}

// Shredder event & handler --------------------------------------------------
// Handler
BOOL JDiscardHandler::handle( JEventData *e)
{
   if( e->msg == DM_DISCARDOBJECT) {
      JDiscardEvent ev( e);
      if( discard( ev)) {
         e->rc = DRR_ABORT;
         return true;
      }
   }
   return false;
}

// Printer event & handler ---------------------------------------------------
BOOL JPrintHandler::handle( JEventData *e)
{
   if( e->msg == DM_PRINTOBJECT) {
      JPrintEvent ev( e);
      if( print( ev)) {
         if( ev.f)
            e->rc = DRR_TARGET;
         else
            e->rc = DRR_SOURCE;
         return true;
      }
   }
   return false;
}
