/*
 * JDrgXfer.cpp
 *
 * Dragndrop rendering classes and handlers
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JDrgXfer.hpp"
#include "JDrgItem.hpp"
#include "JDragSet.hpp"
#include <string.h>
#include "JWindow.hpp"
#define  JDM_RENDERING (WM_USER + 13)

#include "JTrace.hpp"

// Source handler & event ----------------------------------------------------
JSourceRenderEvent::JSourceRenderEvent( JEventData *e, BOOL M)
                   : JEvent( e),
                     xfer( e->mp1()),
                     m( M)
{
   // We don't need a draginfo in the source
}

JSourceRenderEvent::~JSourceRenderEvent()
{
   if( m)
      DrgFreeDragtransfer( (PDRAGTRANSFER) xfer);
}

JStr JSourceRenderEvent::renderTo() const
{
   return JDragItem::getStr( ((PDRAGTRANSFER) xfer)->hstrRenderToName);
}


JDrag::operation JSourceRenderEvent::op() const
{
   return (JDrag::operation) ((PDRAGTRANSFER) xfer)->usOperation;
}

JDragItem JSourceRenderEvent::dragItem() const
{
   return JDragItem( ((PDRAGTRANSFER) xfer)->pditem);
}


// Handler
BOOL JSourceRenderHandler::handle( JEventData *e)
{
   switch( e->msg) {
      case DM_RENDER:
      {
         JSourceRenderEvent ev( e, true); // false);
         BOOL rc = ableToRender( ev);
         PDRAGTRANSFER pDT = (PDRAGTRANSFER) ev.xfer;
         if( rc) {
            // faff around endlessly...
            JDragItem itm = ev.dragItem();
            JStr      to  = ev.renderTo();
            char *fname = strrchr( to.buffer(), '\\') + 1;
            itm.setSourceName( fname);
            itm.setTargetName( fname);
            e->win->postEvent( JDM_RENDERING, ev.xfer, pDT->hwndClient);
            e->rc = true;
         }
         return rc;
      }
      case JDM_RENDERING:
      {
         JSourceRenderEvent ev( e, true);

         render( ev);

         if( !DrgPostTransferMsg( (HWND) e->mp2,
                                  DM_RENDERCOMPLETE,
                                  (PDRAGTRANSFER) e->mp1(),
                                  0, 0, true))
            pmError( 1, "DrgPostXferMsg");
         return true;
      }
      case DM_ENDCONVERSATION:
      {
         // time to free the draginfo ?
         // !! should check lazy count first !!
         if( JDrag::Info.cDragitems > 0) {
            if( !--JDrag::Info.cDragitems) {
               // this free corresponds to the DrgDrag allocate above
               // (ought to assert we're the source)
               DrgFreeDraginfo( (PDRAGINFO) JDrag::Info.pDraginfo);
               JDrag::Info.pDraginfo = 0;
            }
         }

         return true;
      }
   }
   return false;
}

// Target event, handler -----------------------------------------------------
JTargetRenderEvent::JTargetRenderEvent( JEventData *e) : JEvent( e),
                                                         xfer( e->mp1()),
                                                         s( true)
{
   info = DrgQueryDraginfoPtr( 0);
   if( !info)
      pmError( 1, "DrgQueryDraginfoPtr");
   BOOL rc = DrgAccessDraginfo( (PDRAGINFO) info);
   if( !rc)
      pmError( 3, "DrgAccessDraginfo");
}

JTargetRenderEvent::~JTargetRenderEvent()
{
   // yikes!
   DrgDeleteStrHandle( ((PDRAGTRANSFER) xfer)->hstrSelectedRMF);
   DrgDeleteStrHandle( ((PDRAGTRANSFER) xfer)->hstrRenderToName);
   DrgFreeDragtransfer( (PDRAGTRANSFER) xfer);
   DrgDeleteDraginfoStrHandles( (PDRAGINFO) info);
   DrgFreeDraginfo( (PDRAGINFO) info);
}

ulong JTargetRenderEvent::getID() const
{
   return ((PDRAGTRANSFER) xfer)->ulTargetInfo;
}

JStr JTargetRenderEvent::renderedTo() const
{
   return JDragItem::getStr( ((PDRAGTRANSFER) xfer)->hstrRenderToName);
}

JDragItem JTargetRenderEvent::dragItem() const
{
   return JDragItem( ((PDRAGTRANSFER) xfer)->pditem);
}

// Handler
BOOL JTargetRenderHandler::handle( JEventData *e)
{
   if( e->msg == DM_RENDERCOMPLETE) {
      JTargetRenderEvent ev( e);
      if( renderComplete( ev)) {
         ev.dragItem().endConversation( ev.s);
         return true;
      }
   }
   return false;
}

// DragTransfer class; for initiating a rendering operation ------------------
JDragTransfer::JDragTransfer( JDragItem &dItem, const JDrag::rmf &rmf,
                              const char *renderTo, JDrag::operation op,
                              JWindow *yourself)
{
   assertParms( renderTo && yourself, "JDragtransfer::ctor");

   xfer = DrgAllocDragtransfer( 1);
   if( !xfer)
      pmError( 3, "DrgAllocDragtransfer");

   ((PDRAGTRANSFER) xfer)->cb = sizeof( DRAGTRANSFER);
   ((PDRAGTRANSFER) xfer)->hwndClient = yourself->handle();
   ((PDRAGTRANSFER) xfer)->pditem = (PDRAGITEM) dItem.dragitem;
   ((PDRAGTRANSFER) xfer)->hstrSelectedRMF = JDragItem::makeStr( rmf.value());
   ((PDRAGTRANSFER) xfer)->hstrRenderToName = JDragItem::makeStr( renderTo);
   ((PDRAGTRANSFER) xfer)->ulTargetInfo = 0;
   ((PDRAGTRANSFER) xfer)->fsReply = 0;
   ((PDRAGTRANSFER) xfer)->usOperation = (ushort) op;
}

JDragTransfer &JDragTransfer::setID( ulong id)
{
   ((PDRAGTRANSFER) xfer)->ulTargetInfo = id;
   return self;
}

BOOL JDragTransfer::requestRender()
{
   BOOL ok = true;
   ulong rc = 0;
   // need to look for DC_PREPARE & if so, send a DM_RENDERPREPARE
   // to hwndSource in draginfo, which fills in the hwndItem thingy
   // in dragitem with what it wants.
   if( ((PDRAGTRANSFER) xfer)->pditem->fsControl & DC_PREPARE) {
      JDragSet dragset;
      ok = dragset.prepare( xfer);
   }

   if( ok) {
      // hwnditem is now set correctly
      ulong dest = ((PDRAGTRANSFER) xfer)->pditem->hwndItem;
      rc = (ulong) DrgSendTransferMsg( dest, DM_RENDER, xfer, 0);
   }
   if( !rc) {
      DrgDeleteStrHandle( ((PDRAGTRANSFER) xfer)->hstrSelectedRMF);
      DrgDeleteStrHandle( ((PDRAGTRANSFER) xfer)->hstrRenderToName);
      DrgFreeDragtransfer( (PDRAGTRANSFER) xfer);
   }
   return rc;
}
