/*
 * JDropH.cpp
 *
 * Target drag (drop) handler and events
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JDropH.hpp"
#include "JDrgItem.hpp"

// The handler
BOOL JDropHandler::handle( JEventData *e)
{
   switch( e->msg) {
      case DM_DRAGOVER:
      {
         JDragOverEvent ev( e);
         BOOL rc = dragOver( ev);
         if( rc)
            e->rc = JMR( (ushort) ev.ok.state, (ushort) ev.ok.op);
         return rc;
      }
      case DM_DRAGLEAVE:
      {
         JDragLeaveEvent ev( e);
         return dragLeave( ev);
      }
      case DM_DROPHELP:
      {
         BOOL handled;
         JDropHelpEvent ev( e);
         handled = dropHelp( ev); // don't need to do anything;
         return handled;          // DrgDrag will return 0
      }
      case DM_DROP:
      {
         BOOL handled, delay;
         {
            JDropEvent ev( e);
            handled = drop( ev);
            delay = ev.flDelay;
         }
         if( !delay && handled) {
            JDragSet dragset( e->mp1(), true); // delete string handles
            dragset.endConversation();
         }
         return handled;
      }
   }
   return false;
}
