/*
 * JDtTime.cpp
 *
 * Date & time classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JDtTime.hpp"
#include "JStr.hpp"
#include "JMutex.hpp"
#include "JProfile.hpp"

// static functions to the apis ----------------------------------------------
static DATETIME dateTime;
// !! ought to synchronize access to this buffer

static void _gtime()
{
   ulong rc = DosGetDateTime( &dateTime);
   dosError( rc, "DosGetDateTime, bizarrely!");
}

static void _stime()
{
   ulong rc = DosSetDateTime( &dateTime);
   dosError( rc, "DosSetDateTime");
}

// date class ----------------------------------------------------------------
JDate::JDate() // get current date
{
   _gtime();
   d = dateTime.day;
   m = dateTime.month;
   y = dateTime.year;
}

JDate::JDate( const CDATE &c) : d( c.day), m( c.month), y( c.year)
{}

JDate::JDate( const FDATE &f) : d( f.day), m( f.month), y( f.year + 1980)
{}

// !! erm, ought to do this right, but how?
static char *_jmonths[] = { "January", "February", "March", "April", "May",
                            "June", "July", "August", "September",
                            "October", "November", "December" };

JStr JDate::monthName() const
{ return JStr( _jmonths[ m - 1]); }

JStr JDate::date() const
{
   JStr sDate = JProfile::userINI.readString( "sDate", "PM_National");
   int  fDate = JProfile::userINI.readLong( "iDate");
   char *sep = sDate.buffer();
   switch( fDate) {
      case 1: return JVStr( "%d%s%d%s%d", d, sep, m, sep, y);
      case 2: return JVStr( "%d%s%d%s%d", y, sep, m, sep, d);
      case 3: return JVStr( "%d%s%d%s%d", y, sep, d, sep, m);
      default: return JVStr( "%d%s%d%s%d", m, sep, d, sep, y);
   }
}

static char *_jdays[] = { "Sunday", "Monday", "Tuesday", "Wednesday",
                          "Thursday", "Friday", "Saturday" };

static char *_jsuff[] = { "st", "nd", "rd", "th" };

JStr JDate::today()
{
   _gtime();
   int ndex = 3;
   switch( dateTime.day % 10) {
      case 1: ndex = 0;
         break;
      case 2: ndex = 1;
         break;
      case 3: ndex = 2;
   }
   return JVStr( "%s the %d%s of %s %d", _jdays[ dateTime.weekday],
                dateTime.day, _jsuff[ ndex], _jmonths[ dateTime.month - 1],
                dateTime.year);
}

// sets the current (system-wide!) date to the class
JDate &JDate::setCurrentDate()
{
   _gtime();
   dateTime.day = d;
   dateTime.month = m;
   dateTime.year = y;
   _stime();
   return self;
}

// time class ----------------------------------------------------------------
JTime::JTime() // current time
{
   _gtime();
   h = dateTime.hours;
   m = dateTime.minutes;
   s = dateTime.seconds;
}

JTime::JTime( const CTIME &c) : h( c.hours), m( c.minutes), s( c.seconds)
{}

JTime::JTime( const FTIME &f) : h( f.hours), m( f.minutes), s( f.twosecs * 2)
{}

JStr JTime::time() const
{
   BOOL use24 = JProfile::userINI.readLong( "iTime", "PM_National");
   JStr sTime = JProfile::userINI.readString( "sTime");
   char *sep = sTime.buffer();

   const char *fmt = use24 ? "%02d%s%02d%s%02d" : "%d%s%02d%s%02d";

   JVStr tme( fmt, (!use24 && h > 12) ? h-12 : h, sep, m, sep, s);

   if( !use24) {
      JStr sSuffix;
      if( h >= 12) sSuffix = JProfile::userINI.readString( "s2359");
      else         sSuffix = JProfile::userINI.readString( "s1159");

      if( sSuffix.isValid()) { tme.add( ' '); tme.add( sSuffix); }
   }

   return tme;
}

JStr JTime::now()
{
   JTime nowee;
   return nowee.time();
}

JTime &JTime::setCurrentTime()
{
   _gtime();
   dateTime.hours = h;
   dateTime.minutes = m;
   dateTime.seconds = s;
   _stime();
   return self;
}

// combined date & time class ------------------------------------------------
JDateTime::JDateTime() : JTime(), JDate()
{}

JDateTime::JDateTime( const FTIME &t, const FDATE &d) :  JTime( t), JDate( d)
{}

JDateTime::JDateTime( const CTIME &t, const CDATE &d) : JTime( t), JDate( d)
{}

JStr JDateTime::dateTime()
{ return JVStr( "%s %s", JTime::now().buffer(), JDate::today().buffer()); }

JDateTime &JDateTime::setAsCurrent()
{
   setCurrentTime();
   setCurrentDate();
   return self;
}
