/*
 * JEvSem.cpp
 *
 * Event semaphore class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JEvSem.hpp"
#include "JStr.hpp"

void JTimer::stop() const
{
   ulong rc = DosStopTimer( hTimer);
   dosError( rc, "DosStopTimer");
}

JEventSem::JEventSem( const char *nme, BOOL isPosted) : hSem( 0)
{
   ulong rc;
   JVStr  name( "\\SEM32\\%s", nme);

   rc = DosOpenEventSem( name.buffer(), &hSem);
   if( rc == ERROR_SEM_NOT_FOUND)
      rc = DosCreateEventSem( name.buffer(), &hSem, DC_SEM_SHARED, isPosted);

   dosError( rc, "DosCreateEventSem");
}

JEventSem::JEventSem( BOOL shared, BOOL isPosted) : hSem( 0)
{
   ulong rc;
   rc = DosCreateEventSem( NULL, &hSem, shared ? DC_SEM_SHARED : 0, isPosted);
   dosError( rc, "DosCreateEventSem");
}

JEventSem::~JEventSem()
{
   ulong rc = DosCloseEventSem( hSem);
   dosError( rc, "DosCloseEventSem");
}

BOOL JEventSem::post() const
{
   ulong rc = DosPostEventSem( hSem);
   if( rc == ERROR_ALREADY_POSTED) return true;
   dosError( rc, "DosPostEventSem");
   return false;
}

JEventSem &JEventSem::open()
{
   ulong rc = DosOpenEventSem( 0, (PHEV)&hSem);
   dosError( rc, "DosOpenEventSem");
   return self;
}

ulong JEventSem::reset() const
{
   ulong postCount;
   ulong rc = DosResetEventSem( hSem, &postCount);
   dosError( rc, "DosResetEventSem");
   return postCount;
}

JEventSem &JEventSem::wait( ulong time)
{
   ulong rc = DosWaitEventSem( hSem, time);
   dosError( rc, "DosWaitEventSem");
   return self;
}

ulong JEventSem::postCount() const
{
   ulong postCount, rc;
   rc = DosQueryEventSem( hSem, &postCount);
   dosError( rc, "DosQueryEventSem");
   return postCount;
}

JTimer JEventSem::postAfter( ulong ms)
{
   ulong hTimer = 0;
   ulong rc = DosAsyncTimer( ms, (void *) hSem, &hTimer);
   dosError( rc, "DosAsyncTimer");

   return JTimer( hTimer);
}

JTimer JEventSem::postEvery( ulong ms)
{
   ulong hTimer = 0;
   ulong rc = DosStartTimer( ms, (void *) hSem, &hTimer);
   dosError( rc, "DosStartTimer");

   return JTimer( hTimer);
}
