/*
 * JExcept.cpp
 *
 * Exception classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JStr.hpp"
#include "JExcept.hpp"
#include "JTrace.hpp"
#include "JPM.hpp"
#include "JModule.hpp"
#include "Jlibres.h"
#include "JResID.hpp"

// base exception class -----------------
// call to set the text and relay to the trace if appropriate
void JException::setText( const char *s)
{
   text = s;
   if( debugEnabled)
      trace << s;
}

static JStr getMsg( ulong id, char *p1 = 0, char *p2 = 0)
{
   // load a string from our resource dll & format it
   JStr format( JResID( id + j_exn_base), JModule::myResMod);
   if( p1) {
      JVStr str( format.buffer(), p1, p2);
      return str;
   }
   return format;
}

JException::JException( ulong id, JExnType t, char *p1, char *p2) : type( t)
{
   setText( getMsg( id, p1, p2));
}

BOOL JException::debugEnabled = false;

// Thrown on a bad rc from a CP (Dos*) api
JDosExcep::JDosExcep( ulong c, ulong id, char *p)
          : JException( JExn::dos), rc( c)
{
   setText( getMsg( id, p));
}

void JDosExcep::setText( const char *s)
{
   JException::setText( JVStr( "%s Returned %d.", s, rc));
}

// thrown when PM goes wrong
void JPMExcep::setText( const char *s)
{
   // make sure JPM::current & JPM::hab can't throw JMPExcep's !
   code = WinGetLastError( JPM::current()->hab());

   JVStr text( "%s. Sev %d, Reason 0x%x.", s, sev(), error());

   JException::setText( text);
}

JPMExcep::JPMExcep( ulong id, char *p) : JException( JExn::pm)
{
   setText( getMsg( id, p));
}

short JPMExcep::sev()
{
   return ERRORIDSEV( code);
}

short JPMExcep::error()
{
   return ERRORIDERROR( code);
}

void jlib_setup_throw( JException *exn)
{
   JPM *pm( JPM::current());
   delete pm->exn;
   pm->exn = exn;
   pm->type = exn->getType();
}

void jlib_catch()
{
   JPM *pm( JPM::current());
   delete pm->exn;
   pm->exn = 0;
   pm->type = JExn::none;
}

// here because...
#include "JPtr.hpp"
JNullPointer::JNullPointer() : JException( err_nullptr, JExn::base) {}
