/*
 * JFile.hpp
 *
 * Usable disk file classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JFile.hpp"
#include "JBuffer.hpp"

#include <stdio.h>

JRFile::JRFile( const char *n, JStream::sharing s)
       : JRStream(), JFile( n, 1, 1, 1, 0, s)
{}

JWFile::JWFile( const char *n, BOOL append, JStream::sharing s)
       : JWStream(), JFile( n, 0, append, 0, 1, s)
{}

JRWFile::JRWFile( const char *n, JStream::sharing s)
        : JRStream(), JWStream(), JFile( n, 0, 1, 1, s)
{}

JTempFile::JTempFile() : JRWFile( tmpnam( 0), JStream::denyAll)
{}

JTempFile::~JTempFile()
{
   if( handle() != HBAD) {
      close();
      erase();
   }
}
