/*
 * JFind.cpp
 *
 * File-finder classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JFind.hpp"

#ifndef HBAD
#define HBAD ((ulong)-1)
#endif

static const JStr _Bad_Find( "Bleugh!");
#define check if( !isValid()) badcursor

JFind::JFind( const char *filespec, JFind::findspec spc)
      : file( filespec),  hDir( HBAD), spec( (ulong) spc)
{
   assertParms( filespec, "JFind::JFind");
}

JFind::~JFind()
{
   if( hDir != HBAD) {
      ulong rc = DosFindClose( hDir);
      dosError( rc, "DosFindClose");
   }
}

JFind &JFind::toFirst()
{
   FILEFINDBUF3 buff;
   ulong        req = 1;

   ulong rc = DosFindFirst( file, &hDir, spec, &buff,
                            sizeof( FILEFINDBUF3), &req, 1);
   if( rc == ERROR_NO_MORE_FILES  || rc == 2 || rc == ERROR_PATH_NOT_FOUND)
      curr = _Bad_Find;
   else {
      dosError( rc, "DosFindFirst");
      if( !rc) {
         if( req != 1) curr = _Bad_Find;
         else curr = buff.achName;
      }
   }
   return self;
}

JFind &JFind::toNext()
{
   if( !isValid()) badcursor;
   else {
      FILEFINDBUF3 buff;
      ulong        req = 1;
      ulong rc = DosFindNext( hDir, &buff, sizeof( FILEFINDBUF3), &req);
      if( rc == ERROR_NO_MORE_FILES)
         curr = _Bad_Find;
      else {
         dosError( rc, "DosFindNext");
         if( !rc) {
            if( req != 1) curr = _Bad_Find;
            else curr = buff.achName;
         }
      }
   }
   return self;
}

BOOL JFind::isValid() const
{
   return curr != _Bad_Find;
}

JStr JFind::current() const
{
   if( !isValid()) badcursor;
   return curr;
}

void JFind::files( const char *file, JSet<JStr> &list, JFind::findspec spc)
{
   JFind finder( file, spc);

   list.empty();

   for_cursor( finder)
      list.add( JStr( finder.current()));
}
