/*
 * JFocusH.hpp
 *
 * Focus change message handler & event classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "JOs2.h"
#include "JFocusH.hpp"
#include "JWindow.hpp"

// Event ----------------------------------------------------------------------
JFocusChangeEvent::JFocusChangeEvent( JEventData *e) : JEvent( e)
{
   if( e->msg == WM_SETFOCUS) {
      if( e->mp1())
         oter = JWindowPtr( e->mp1);
      else oter = 0;
   } else {
      if( e->mp2())
         oter = JWindowPtr( e->mp2);
      else oter = 0;
   }
}

// Handler --------------------------------------------------------------------
BOOL JFocusChangeHandler::handle( JEventData *e)
{
   switch( e->msg) {
      case WM_ACTIVATE:
         if( e->mp1 == true)
            return activated( JFocusChangeEvent( e));
         else
            return deactivated( JFocusChangeEvent( e));
      case WM_SETFOCUS:
         if( e->mp2 == true)
            return gainedFocus( JFocusChangeEvent( e));
         else
            return lostFocus( JFocusChangeEvent( e));
      case WM_SETSELECTION:
         if( e->mp1 == true)
            return selected( JEvent( e));
         else
            return deselected( JEvent( e));
   }
   return false;
}
