/*
 * JFrmeCtl.cpp
 *
 * Abstract frame control class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "JOs2.h"
#include "JFrmeCtl.hpp"
#include "JFrame.hpp"
#include "JSWP.hpp"
#include "JCoord.hpp"

// All we have here is default implementations for doing the vaguely tricky
// stuff to handle messages from the frame about setting position and suchlike

void JFrameCtl::format( JSWPArray &swps, JSWP &mySwp, JFrame *frame)
{
   short client( swps.indexOf( JFrame::idClient));
   JSWP *swpCli = *(swps[ client]);

   long  ctlHeight( ctl->size().y);

   // set our width to client width; height from the control
   mySwp.width() = swpCli->width();
   mySwp.height() = ctlHeight;

   // position control at top or bottom of client area...
   mySwp.x() = swpCli->x();
   mySwp.y() = swpCli->y();
   if( pos == JFrameCtl::aboveClient) {
      mySwp.y() += swpCli->height() - ctlHeight;
   }
}

void JFrameCtl::adjustClientRect( JRect *cli) const
{
   long ctlHeight( ctl->size().y);

   if( pos == JFrameCtl::aboveClient) {
      cli->max.y -= ctlHeight;
   } else {
      cli->min.y += ctlHeight;
   }
}
