/*
 * JGrpBox.cpp
 *
 * Group box control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JGrpBox.hpp"
#include "JControl.hpp"
#include "JWindow.hpp"
#include "JCoord.hpp"
#include "JIntern.hpp"

JGroupBox::JGroupBox( JWindow *parent, const JPoint &position,
                      const JSize &size, ulong ID, const char *text) : JControl()
{
   assertParms( parent, "JGroupBox::JGroupBox");

   JCreateWBlock b( parent->handle(), WC_STATIC, (char*)text,
                    JWindow::visible | SS_GROUPBOX, position, size,
                    parent->handle(), HWND_TOP, ID, 0, 0);

   setHwnd( JInternal::window::create( &b));
}
