/*
 * JHelp.cpp
 *
 * Help manager class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "JOs2.h"
#include "JHelp.hpp"
#include "JWindow.hpp"
#include "JResID.hpp"
#include "JPM.hpp"

// Help manager --------------------------------------------------------------
JHelpManager::JHelpManager() : tut( 0), help( 0), hModel( JHelpManager::none)
{}

JHelpManager::~JHelpManager()
{
   if( hModel != JHelpManager::none) {
      WinDestroyHelpInstance( help->handle());
      delete help;
   }
}

// Setup methods -------------------------------------------------------------
JHelpManager &JHelpManager::initialise( const char *lib, const char *title,
                                        JTutorial *t)
{
   assertParms( lib && title && hModel == JHelpManager::none, "JHelpMan");
   tut = t;
   HELPINIT hInit = { sizeof( HELPINIT), 0, tut ? tut->name().buffer() : 0,
                      0, 0, 0, 0, 0, (char*)title, 0, (char*)lib };

   ulong hwndHelp = WinCreateHelpInstance( JPM::current()->hab(), &hInit);
   if( !hwndHelp || hInit.ulReturnCode)
      pmError( 2, "WinCreateHelpInstance");

   help = new JWindow( hwndHelp);
   hModel = JHelpManager::dynamic;
   return self;
}

// Using helptables
JHelpManager &JHelpManager::initialise( const char *lib, const char *title,
                                        const JResID &id, const JModule &mod,
                                        JTutorial *t)
{
   assertParms( lib && title && hModel == JHelpManager::none, "JHelpMan");
   tut = t;
   HELPINIT hInit = { sizeof( HELPINIT), 0, tut ? tut->name().buffer() : 0,
                      (PHELPTABLE) (id.value() | 0xffff0000), // !!
                      mod, 0, 0, 0, (char*)title, 0, (char*)lib };

   ulong hwndHelp = WinCreateHelpInstance( JPM::current()->hab(), &hInit);
   if( !hwndHelp || hInit.ulReturnCode)
      pmError( 2, "WinCreateHelpInstance");

   help = new JWindow( hwndHelp);
   hModel = JHelpManager::resource;
   return self;
}

// Help model
JHelpManager &JHelpManager::setGeneralID( const JHelpID &h)
{
   generalID = h;
   return self;
}

JHelpManager &JHelpManager::setKeysHelpID( const JHelpID &h)
{
   keysHelp = h;
   return self;
}

// Displaying help -----------------------------------------------------------
JHelpManager &JHelpManager::showHelp( const JHelpID &h)
{
   assertParms( help && hModel != JHelpManager::none, "JHelpMan");
   ulong rc = help->sendEvent( HM_DISPLAY_HELP, h.ID());
   if( rc)
      pmError( 2, "HM_DISPLAY_HELP");
   return self;
}

JHelpManager &JHelpManager::showIndex()
{
   assertParms( help && hModel != JHelpManager::none, "JHelpMan");
   ulong rc = help->sendEvent( HM_HELP_INDEX);
   if( rc)
      pmError( 2, "HM_HELP_INDEX");
   return self;
}

JHelpManager &JHelpManager::showContents()
{
   assertParms( help && hModel != JHelpManager::none, "JHelpMan");
   ulong rc = help->sendEvent( HM_HELP_CONTENTS);
   if( rc)
      pmError( 1, "HM_HELP_CONTENTS");
   return self;
}

JHelpManager &JHelpManager::showKeysHelp()
{
   assertParms( help && hModel != JHelpManager::none, "JHelpMan");
   ulong rc = help->sendEvent( HM_KEYS_HELP);
   if( rc)
      pmError( 2, "HM_KEYS_HELP");
   return self;
}

JHelpManager &JHelpManager::showUsingHelp()
{
   assertParms( help && hModel != JHelpManager::none, "JHelpMan");
   help->sendEvent( HM_DISPLAY_HELP);
   return self;
}

// Replace the using help panel ----------------------------------------------
JHelpManager &JHelpManager::replaceUsingHelp( const JHelpID &h)
{
   assertParms( help && hModel != JHelpManager::none, "JHelpMan");
   ulong rc = help->sendEvent( HM_REPLACE_USING_HELP, h.ID());
   if( rc)
      pmError( 3, "HM_REPLACE_USING_HELP");
   return self;
}

// Set an associated window --------------------------------------------------
JHelpManager &JHelpManager::associate( JWindow *w)
{
   assertParms( w && help && hModel != JHelpManager::none, "JHelpMan");
   BOOL rc = WinAssociateHelpInstance( help->handle(), w->handle());
   if( !rc)
      pmError( 2, "WinAssociateHelpInstance");
   return self;
}

JHelpManager &JHelpManager::setActiveWindow( JWindow *w)
{
   assertParms( /*w &&*/ help && hModel != JHelpManager::none, "JHelpMan");
   if( w)
      help->sendEvent( HM_SET_ACTIVE_WINDOW, w->handle(), w->handle());
   else
      help->sendEvent( HM_SET_ACTIVE_WINDOW);
   return self;
}

// Help manager object -------------------------------------------------------
JHelpManager HelpManager;
