/*
 * JIcon.cpp
 *
 * Icon class - for display, pointer setting etc.
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JIcon.hpp"
#include "JCoord.hpp"
#include "JWindow.hpp"
#include "JModule.hpp"
#include "JResID.hpp"
#include "JBitmap.hpp"

// Data class -----------------------------------------------------------------
// ho hum, this is probably overkill, but hey.
struct JIconData
{
   ulong hIcon;
   BOOL  del;
   JIconData() : hIcon( 0), del( true) {}
  ~JIconData() {
      if( del && ( false == WinDestroyPointer( hIcon)))
         pmError( 3, "WinDestroyPointer");
   }
};


// constructors: wrap a handle ------------------------------------------------
JIcon::JIcon( ulong hP) : data( new JIconData)
{
   assertParms( hP, "JIcon::JIcon");
   data->hIcon = hP; data->del = false;
}

// create an icon from a bitmap somehow
JIcon::JIcon( const JBitmap &bmp, const JPoint &hot, BOOL ptrStretch)
      : data( new JIconData)
{
   data->hIcon = WinCreatePointer( JWindow::theDesktopWindow,
                                   bmp.handle(),
                                   ptrStretch,
                                   hot.x,
                                   hot.y);
   if( !data->hIcon)
      pmError( 1, "WinCreatePointer");
}

// copy ctor
JIcon::JIcon( const JIcon &copy) : data( new JIconData)
{
   data->hIcon = copy.data->hIcon;
   data->del = copy.data->del; copy.data->del = false;
}

// load from a resource file
JIcon::JIcon( const JResID &id, const JModule &mod) : data( new JIconData)
{
   data->hIcon = WinLoadPointer( JWindow::theDesktopWindow,
                                 mod,
                                 id.value());
   if( !data->hIcon)
      resError( "pointer/icon");
}

JIcon::~JIcon()
{
   delete data;
}

// low level handle access ----------------------------------------------------
JIcon::operator ulong ()
{ return data->hIcon; }

ulong JIcon::handle() const
{ return data->hIcon; }

// Get various fields from the pointerinfo structure --------------------------
JBitmap JIcon::getBitmap()
{
   POINTERINFO pInfo;

   BOOL rc = WinQueryPointerInfo( data->hIcon, &pInfo);
   if( !rc)
      pmError( 3, "WinQueryPointerInfo");

   return JBitmap( pInfo.hbmPointer);
}

JPoint JIcon::getHotspot()
{
   POINTERINFO pInfo;

   BOOL rc = WinQueryPointerInfo( data->hIcon, &pInfo);
   if( !rc)
      pmError( 3, "WinQueryPointerInfo");

   return JPoint( pInfo.xHotspot, pInfo.yHotspot);
}

// Get a system icon ----------------------------------------------------------
JIcon JIcon::sysPointer( sys type, BOOL privat)
{
   JIcon icon( WinQuerySysPointer( JWindow::theDesktopWindow, type, privat));
   icon.data->del = privat;

   return icon;
}
