/*
 * JIntern.cpp
 *
 * Internal functions, used from various places - fudge.
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"

#ifdef __EMX__
// emx is a bit confused about which bits of it define what types.
#define INCL_OS2MM
#include <os2me.h>
#define INCL_GRAPHICBUTTON
extern "C" {
#include <sw.h>
}
#else
// vacpp isn't
#define INCL_SW
#include <os2me.h>
#endif

#include "JIntern.hpp"
#include "JPM.hpp"
#include "JThreadI.hpp"
#include "JMWindow.hpp"
#include "JEvent.hpp"

// After window and pm are running
#pragma priority( -998)

// Bits for managing our custom pm window-classes -----------------------------
static char *clsname1 = "JLibClass";
static char *clsname2 = "JLibClass2";

char *JInternal::window::name() { return clsname1; }

char *JInternal::window::SRName() { return clsname2; }

// bits for threading window creation -----------------------------------------

// Data structure for passing WCW parameters around threads
JCreateWBlock::JCreateWBlock( ulong p, char *c, char *n, ulong s,
                              const JPoint &pt, const JSize &sz, ulong o,
                              ulong b, ulong id, void *v1, void *v2)
   : parent( p), clss( c), name( n), style( s), pos( pt), size( sz), owner( o),
     behind( b), ID( id), ctldata( v1), pparams( v2) {}

#define JWM_CREATE    WM_USER
#define JWM_CREATEDLG (WM_USER + 1)
#define JWM_DESTROY   (WM_USER + 2)
#define JWM_PRODLG    (WM_USER + 3)

// Window class which routes WCW messages around threads
class JTWindow : public JMWindow
{
 public:
   JTWindow() : JMWindow()
   {}
   BOOL preHandleEvents( JEventData *e)
   {
      BOOL rc = false;

      switch( e->msg) {
         case JWM_CREATE:
            e->rc = JInternal::window::create( (JCreateWBlock *) e->mp1());
            rc = true;
            break;
         case JWM_CREATEDLG:
            e->rc = JInternal::dialog::createDlg( (JCreateDlg *) e->mp1());
            rc = true;
            break;
         case JWM_DESTROY:
            JInternal::window::destroy( e->mp1);
            rc = true;
            break;
         case JWM_PRODLG:
            e->rc = JInternal::dialog::process( e->mp1);
            rc = true;
            break;
      }

      return rc;
   }
};

extern MRESULT EXPENTRY fnwpSplit( HWND, ULONG, MPARAM, MPARAM);

// Static class which records the main threadid & message router window
struct windowthreader
{
   ulong     tidMain;
   JTWindow *maker;

   windowthreader() : tidMain( JThreadInfo::tid()), maker( new JTWindow)
   {
      ulong hab = JPM::current()->hab();
      // register a couple of window classes for creating with
      // we do it here for convenience...
      BOOL rc = WinRegisterClass( hab,
                                  clsname1,
                                  WinDefWindowProc,
                                  0,
                                  0);
      if( !rc)
         pmError( 1, "WinRegisterClass");

      rc = WinRegisterClass( hab,
                             clsname2,
                             WinDefWindowProc,
                             CS_SIZEREDRAW,
                             0);
      if( !rc)
         pmError( 2, "WinRegisterClass");

      // any additional window classes & startup stuff should happen here
      // register split
      WinRegisterClass( hab, WC_SPLIT, fnwpSplit, 0, 4);

      // graphic button (is this really necessary?)
      WinRegisterGraphicButton();
   }
  ~windowthreader()
   {
      if( maker)
         delete maker;
   }
} windowThreader;

// Called when we want to create a window.
ulong JInternal::window::create( JCreateWBlock *b)
{
   // Check PM is running
   JPM::current();

   ulong hwnd = 0;

   // If we're in the main thread, fine.
   if( JThreadInfo::tid() == windowThreader.tidMain)
      // create the window here
      hwnd = WinCreateWindow( b->parent, b->clss, b->name, b->style,
                              b->pos.x, b->pos.y, b->size.x,
                              b->size.y, b->owner, b->behind, b->ID,
                              b->ctldata, b->pparams);
   else
      // tell the main thread to create the window
      hwnd = windowThreader.maker->sendEvent( JWM_CREATE, b);

   // throw up if things went all wrong
   if( !hwnd)
      pmError( 1, "WinCreateWindow");

   return hwnd;
}

ulong JInternal::window::create( const JCreateWBlock &b)
{ return JInternal::window::create( &((JCreateWBlock &) b)); }

ulong JInternal::dialog::createDlg( JCreateDlg *cd)
{
   ulong hwnd = 0;

   if( JThreadInfo::tid() == windowThreader.tidMain)
      hwnd = WinLoadDlg( cd->hwndP, cd->hwndO, WinDefDlgProc,
                         cd->hMod, cd->id, NULL);
   else
      hwnd = windowThreader.maker->sendEvent( JWM_CREATEDLG, cd);

   if( !hwnd) pmError( 2, "WinLoadDlg");

   return hwnd;
}

ulong JInternal::dialog::createDlg( const JCreateDlg &b)
{ return JInternal::dialog::createDlg( &((JCreateDlg &) b)); }

ulong JInternal::dialog::process( ulong hwnd)
{
   ulong rc = 0;

   if( JThreadInfo::tid() == windowThreader.tidMain)
      rc = WinProcessDlg( hwnd);
   else
      rc = windowThreader.maker->sendEvent( JWM_PRODLG, hwnd);

   return rc;
}

void JInternal::window::destroy( ulong hwnd)
{
   if( JThreadInfo::tid() == windowThreader.tidMain ||
       WinIsChild( hwnd, HWND_OBJECT)) {
      if( !WinDestroyWindow( hwnd))
         pmError( 3, "WinDestroyWindow");
   } else {
      windowThreader.maker->sendEvent( JWM_DESTROY, hwnd);
   }
}
