/*
 * JKeyH.cpp
 *
 * Keypress (WM_CHAR) handler and event
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JKeyH.hpp"

BOOL JKeyEvent::hasAlt() const
{
   return e->mp1.s1() & KC_ALT;
}

BOOL JKeyEvent::hasShift() const
{
   return e->mp1.s1() & KC_SHIFT;
}

BOOL JKeyEvent::hasCtrl() const
{
   return e->mp1.s1() & KC_CTRL;
}

BOOL JKeyEvent::isVk() const
{
   return e->mp1.s1() & KC_VIRTUALKEY;
}

BOOL JKeyEvent::isChar() const
{
   return e->mp1.s1() & KC_CHAR;
}

BOOL JKeyEvent::isKeyUp() const
{
   return e->mp1.s1() & KC_KEYUP;
}

// Handler --------------------------------------------------------------------
BOOL JKeyHandler::handle( JEventData *e)
{
   if( e->msg == WM_CHAR)
      return keypress( JKeyEvent( e));
   return false;
}
