/*
 * JModule.cpp
 *
 * Dynamic Link Library (including resource dlls) classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JModule.hpp"
#include "JStr.hpp"

#include <stdlib.h>

JModule::~JModule()
{
   if( hMod)
      DosFreeModule( hMod);
}

void JModule::load( const char *mod)
{
   APIRET rc;
   char   buffer[ CCHMAXPATH]; // !! could do something with this

   rc = DosLoadModule( buffer, 200, mod, &hMod);
   dosError( rc, "DosLoadModule");
}

char *JModule::nameOf( ulong h)
{
   APIRET rc;
   JStr   name; name.setsize( CCHMAXPATH);

   rc = DosQueryModuleName( h, CCHMAXPATH, name.buffer());
   dosError( rc, "DosQueryModuleName");

   return strdup( name);
}

ulong JModule::handleOf( const char *c)
{
   APIRET  rc;
   HMODULE hm;

   rc = DosQueryModuleHandle( c, &hm);
   dosError( rc, "DosQueryModuleHandle");

   return hm;
}

pfn JModule::getProc( ulong ord) const
{
   APIRET rc;
   PFN    pf;

   rc = DosQueryProcAddr( hMod, ord, NULL, &pf);
   dosError( rc, "DosQueryProcAddr");

   return (pfn) pf;
}

pfn JModule::getProc( const char *c) const
{
   APIRET rc;
   PFN    pf;

   rc = DosQueryProcAddr( hMod, 0, c, &pf);
   dosError( rc, "DosQueryProcAddr");

   return (pfn) pf;
}

JModule JModule::theResMod;
JModule JModule::myResMod( "JLibRes");
