/*
 * JMouseH.cpp
 *
 * Mouse event handlers and events
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "JOs2.h"
#include "JMouseH.hpp"

// Base event; doesn't know about the state of the keyboard -------------------
// stupidly, wm_open & wm_edittext have their parameters on backwards.
JPoint JMouseEvent::pos() const
{ return JPoint( i ? e->mp2.s1() : e->mp1.s1(), i ? e->mp2.s2() :e->mp1.s2()); }

// Click event; contains knowledge of any modifer keys ------------------------
BOOL JClickEvent::hasAlt() const
{ return e->mp2.s2() && KC_ALT; }

BOOL JClickEvent::hasShift() const
{ return e->mp2.s2() && KC_SHIFT; }

BOOL JClickEvent::hasCtrl() const
{ return e->mp2.s2() && KC_CTRL; }

// CUA Handler ----------------------------------------------------------------
BOOL JCUAMouseHandler::handle( JEventData *e)
{
   switch( e->msg) {
      case WM_BEGINSELECT:
         return beginSelect( JMouseEvent( e));
      case WM_ENDSELECT:
         return endSelect( JMouseEvent( e));
      case WM_SINGLESELECT:
         return singleSelect( JMouseEvent( e));
      case WM_TEXTEDIT:
         return textEdit( JMouseEvent( e, true));
      case WM_OPEN:
         return open( JMouseEvent( e, true));
      case WM_CONTEXTMENU:
         return contextMenu( JMouseEvent( e));
   }
   return false;
}

// Normal Handler. For real men. ----------------------------------------------
BOOL JMouseHandler::handle( JEventData *e)
{
   JClickEvent ev( e);

   switch( e->msg) {
      case WM_BUTTON1CLICK:
         return button1click( ev);
      case WM_BUTTON1DBLCLK:
         return button1doubleClick( ev);
      case WM_BUTTON1DOWN:
         return button1down( ev);
      case WM_BUTTON1UP:
         return button1up( ev);
      case WM_BUTTON2CLICK:
         return button2click( ev);
      case WM_BUTTON2DBLCLK:
         return button2doubleClick( ev);
      case WM_BUTTON2DOWN:
         return button2down( ev);
      case WM_BUTTON2UP:
         return button2up( ev);
      case WM_CHORD:
         return chord( ev);
      case WM_MOUSEMOVE:
         return mouseMove( ev);
   }
   return false;
}

// Enter-exit handler ---------------------------------------------------------
BOOL JMouseEnterExitHandler::handle( JEventData *e)
{
   BOOL rc = false;

   switch( e->msg) {
      case 0x041e:
         rc = mouseEnter( JEvent( e));
         break;
      case 0x041f:
         rc = mouseLeave( JEvent( e));
         break;
   }

   return rc;
}
