/*
 * JMsgFile.cpp
 *
 * Message file class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JMsgFile.hpp"
#include "JStr.hpp"

JStr JMsgFile::getMsg( ulong msgNum, const char *a1, const char *a2,
                       const char *a3, const char *a4, const char *a5,
                       const char *a6, const char *a7, const char *a8,
                       const char *a9)
{
   // set up table of pointers and work out how many there are
   const char *table[ 9] = { a1, a2, a3, a4, a5, a6, a7, a8, a9 };
   int   i;

   for( i = 0; i < 9; i++)
      if( !table[ i]) break;

   // then get the message into a string
   APIRET rc;
   ulong  returned;

   JStr buffer( "I'm a bug");
   buffer.setsize( 1024); // !! is this just arbitrary ?

   rc = DosGetMessage( (PCHAR*)table, i, buffer, 1024, msgNum, filename, &returned);
   if( rc)
      jlib_throw( new JException( err_msgloadfailed, JExn::base));
   else {

      if( returned) {
         buffer.setsize( returned + 1);
         buffer[ returned] = 0;
      }
   }

   return buffer;
}
