/*
 * JMutex.cpp
 *
 * Mutex semaphore class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JStr.hpp"
#include "JMutex.hpp"

JMutexSem::JMutexSem( const char *nme) : hSem( 0)
{
   ulong rc;
   JVStr  name( "\\SEM32\\%s", nme);

   rc = DosOpenMutexSem( name.buffer(), &hSem);

   if( rc == ERROR_SEM_NOT_FOUND)
      rc = DosCreateMutexSem( name.buffer(), &hSem, DC_SEM_SHARED, false);

   dosError( rc, "DosCreateMutexSem");
}

JMutexSem::JMutexSem() : hSem( 0)
{
   ulong rc = DosCreateMutexSem( NULL, &hSem, 0, false);
   dosError( rc, "DosCreateMutexSem");
}

JMutexSem::~JMutexSem()
{
   ulong rc = DosCloseMutexSem( hSem);
   dosError( rc, "DosCloseMutexSem");
}

void JMutexSem::request( ulong wait) const
{
   ulong rc = DosRequestMutexSem( hSem, wait);
   dosError( rc, "DosRequestMutexSem");
}

void JMutexSem::release() const
{
   ulong rc = DosReleaseMutexSem( hSem);
   dosError( rc, "DosReleaseMutexSem");
}
