/*
 * JNPipes.cpp
 *
 * Named-pipe stream classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JNPipes.hpp"

JRNamedPipe::JRNamedPipe( const char *n, ulong time, const char *srv)
            : JRStream(), JPipeClient( n, srv, time, 1, 0)
{}

JWNamedPipe::JWNamedPipe( const char *n, ulong time, const char *srv)
            : JWStream(), JPipeClient( n, srv, time, 0, 1)
{}

JRWNamedPipe::JRWNamedPipe( const char *n, ulong tme, const char *srv)
             : JRStream(), JWStream(), JPipeClient( n, srv, tme, 1, 1)
{}

JRPipeServer::JRPipeServer( const char *name, ulong cbIn, ulong cbOut,
                            uchar inst, ulong wait, BOOL isBP, BOOL oBte, BOOL blk)
             : JPipeServer( name, 1, 0, isBP, inst, blk, oBte, cbIn, cbOut, wait),
               JRStream()
{}

JWPipeServer::JWPipeServer( const char *name, ulong cbIn, ulong cbOut, uchar inst,
                            ulong wait, BOOL isBP, BOOL oBte, BOOL blk)
             : JPipeServer( name, 0, 1, isBP, inst, blk, oBte, cbIn, cbOut, wait),
               JWStream()
{}

JRWPipeServer::JRWPipeServer( const char *name, ulong cbIn, ulong cbOut, uchar inst,
                              ulong wait, BOOL isBP, BOOL oBte, BOOL blk)
              : JPipeServer( name, 1, 1, isBP, inst, blk, oBte, cbIn, cbOut, wait),
                JRStream(), JWStream()
{}
