/*
 * JOpenDlg.cpp
 *
 * The open file dialog. Ought to use dragndrop, but hey...
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JPM.hpp"
#include "JOpenDlg.hpp"
#include "JFile.hpp"
#include "JMsgbox.hpp"
#include "JEvent.hpp"

#include <string.h>

// style ---------------------------------------------------------------------
const ulong JOpenDlg::normal      = 0;
const ulong JOpenDlg::helpButton  = FDS_HELPBUTTON;
const ulong JOpenDlg::multiSelect = FDS_MULTIPLESEL;

// private data area ---------------------------------------------------------
struct JOpenDlgData
{
   FILEDLG         f;
   JWindow        *owner;
   JOpenDlgClient *c;
   ulong           id;

   JOpenDlgData( JWindow *w) : owner( w), c( 0), id( 0) {
      memset( &f, 0, sizeof( FILEDLG));
      f.cbSize = sizeof( FILEDLG);
   }
};

// loading thread thingy -----------------------------------------------------
ulong JOpenDlg::operator () ()
{
   // Create a list of the filenames
   JSequence<JStr> strlist;

   if( data->f.fl & FDS_MULTIPLESEL) {
      for( ulong i = 0; i < data->f.ulFQFCount; i++)
         strlist.append( JStr( data->f.papszFQFilename[ 0][i]));
      // free the winfiledlgdata thing
      BOOL rc = WinFreeFileDlgList( data->f.papszFQFilename);
      if( !rc)
         pmError( 2, "WinFreeFileDlgList");
   } else
      strlist.append( JStr( data->f.szFullFile));

   JSequence<JOpenDlgFile> files( strlist.elements());
   JSequence<JStr>::cursor c( strlist);
   BOOL                    errors = false;

   JMsgBox mbox( &JWindow::theDesktopWindow, "Eek! I'm a bug", "Error",
                 JMsgBox::ok, JMsgBox::error);

   // cursor through the list
   for_cursor( c) {
#ifdef REALLY_THROW_EXCEPTIONS
      try {
#endif
         // loading each file as we go
         JRFile  file( *c.current());
         JBuffer buffet( file.size());

         file.read( buffet);

         files.append( JOpenDlgFile( *c.current(), buffet));
         // !! make JBuffer reference counted
#ifdef REALLY_THROW_EXCEPTIONS
      } catch( JException *) {
#else
      if( JPM::current()->exn) {
         jlib_catch();
#endif
         // have a separate error check on each file
         mbox.setMessage( JVStr( "Error opening %s.", c.current()->buffer()));
         mbox.openOverPointer();
         errors = true;
      }
   }

   // notify the client of any errors at the end
   if( errors)
      data->c->openingError( data->id);

   // give the client the file list
   data->c->openedFiles( files, data->id);

   // suicide on return
   return 0;
}

BOOL JOpenDlg::preHandleEvents( JEventData *e)
{
   if( e->msg == JThread::overMsgID) {
      delete this;
      return true;
   } else
      return false;
}

// opendlg class; ctor / dtor ------------------------------------------------
JOpenDlg::JOpenDlg( JWindow *w, const char *name, ulong sty,
                    const char *ft, const char *title, const char *okbutton)
         : data( new JOpenDlgData( w)), JMWindow()
{
   assertParms( w && name, "JOpenDlg::ct");
   data->f.fl = sty | FDS_CENTER | FDS_OPEN_DIALOG;
   data->f.pszTitle = strdup( title);
   data->f.pszOKButton = strdup( okbutton);
   data->f.pszIType = (char*)ft;
   strcpy( data->f.szFullFile, name);
}

void JOpenDlg::makeSaveDialog()
{
   data->f.fl &= ~FDS_OPEN_DIALOG;
   data->f.fl |= FDS_SAVEAS_DIALOG;
}

JOpenDlg::~JOpenDlg()
{
   ::free( data->f.pszTitle);
   ::free( data->f.pszOKButton);
   delete data;
}

// running methods -----------------------------------------------------------
JStr JOpenDlg::run( BOOL *cancel)
{
   ulong hwnd = WinFileDlg( HWND_DESKTOP, data->owner->handle(), &data->f);
   if( !hwnd)
      pmError( 3, "WinFileDlg");
   *cancel = (DID_CANCEL == data->f.lReturn);

   JStr s( data->f.szFullFile);
   delete this;
   return s;
}

BOOL JOpenDlg::run( JOpenDlgClient *client, ulong Dd)
{
   ulong hwnd = WinFileDlg( HWND_DESKTOP, data->owner->handle(), &data->f);
   if( !hwnd)
      pmError( 3, "WinFileDlg");
   if( DID_CANCEL == data->f.lReturn)
      return false;

   data->c = client; data->id = Dd;

   // kick off loading thread
   start();

   return true;
}

// fileitem class ------------------------------------------------------------
JOpenDlgFile::JOpenDlgFile( const JStr &n, const JBuffer &d)
             : fname( n), data( d) {}

JOpenDlgFile::JOpenDlgFile( const JOpenDlgFile &copy)
             : fname( copy.fname), data( copy.data) {}
