/*
 * JOwnerDH.cpp
 *
 * Owner-draw events and handler classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JOwnerDH.hpp"
#include "JPSpace.hpp"

// Drawitemevent --------------------------------------------------------------
JBPSpace JDrawItemEvent::ps() const
{
   return JBPSpace( ((POWNERITEM) p)->hps);
}

long JDrawItemEvent::itemID() const
{
   return ((POWNERITEM) p)->idItem;
}

ulong JDrawItemEvent::itemHandle() const
{
   return ((POWNERITEM) p)->hItem;
}

JRect JDrawItemEvent::itemRect() const
{
   return JRect( ((POWNERITEM) p)->rclItem);
}

ulong &JDrawItemEvent::oldState() const
{
   return ((POWNERITEM) p)->fsStateOld;
}

ulong &JDrawItemEvent::state() const
{
   return ((POWNERITEM) p)->fsState;
}

// Handler --------------------------------------------------------------------
BOOL JOwnerDrawHandler::handle( JEventData *e)
{
   BOOL rc = false;

   if( e->mp1 == ctlId || ctlId == (ulong)-1) {
      if( e->msg == WM_MEASUREITEM)
         rc = measureItem( JMeasureEvent( e));
      else if( e->msg == WM_DRAWITEM)
         rc = drawItem( JDrawItemEvent( e));
   }

   return rc;
}
