/*
 * JPM.cpp
 *
 * Implementation for simple PM class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JPM.hpp"
#include "JThreadI.hpp"
#include "JWindow.hpp"
#include "JIntern.hpp"

#include "JSafeHT.hpp"

#pragma priority( -1000)

JSafeHTable<JPM*,TID> pmtable;

static JPM _jlib_static_jpm;

JPM *JPM::current()
{
   ulong tid( JThreadInfo::tid());
#ifdef REALLY_THROW_EXCEPTIONS
   try {
#endif
      JPM **p = pmtable.get( tid);
#ifdef REALLY_THROW_EXCEPTIONS
      return *p;
#else
      if( p) return *p;
      else jlib_catch();
#endif
#ifdef REALLY_THROW_EXCEPTIONS
   } catch( JException *) {
   }
#endif

   jlib_throw( new JException( err_nopm, JExn::base)); // shouldn't happen...
   return 0;
}

JPM::JPM() : exn( 0), type( JExn::none)
{
   _hab = WinInitialize( 0);
   if( !_hab)
      pmError( 4, "WinInitialize");

   _hmq = WinCreateMsgQueue( _hab, 0);
   if( !hmq)
      pmError( 3, "WinCreateMsgQueue");

   pmtable.put( JThreadInfo::tid(), this);
}

JPM::~JPM()
{
   pmtable.remove( JThreadInfo::tid());

   WinDestroyMsgQueue( _hmq);
   WinTerminate( _hab);

   delete exn;
}

void JPM::process() const
{
   QMSG qmsg;

   for( ; ;) {
      while( WinGetMsg( _hab, &qmsg, 0, 0, 0))
         WinDispatchMsg( _hab, &qmsg);

      if( qmsg.hwnd)
         // send WM_SYSCOMMAND, SC_CLOSE to window (tasklist close)
         JWindow::SendEvent( qmsg.hwnd, WM_SYSCOMMAND, SC_CLOSE);
      else if( !quitting())
         break;
   }
}

JPM &JPM::quit()
{
   WinPostQueueMsg( _hmq, WM_QUIT, 0, 0);
   return self;
}
