/*
 * JPaintH.cpp
 *
 * Paint event and handler classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "jos2.h"
#include "JPaintH.hpp"
#include "JWindow.hpp"

JPaintEvent::JPaintEvent( JEventData *e) : JEvent( e), needToZap( false)
{}

void JPaintEvent::begin( JBPSpace *ready)
{
   if( ready) {
      WinBeginPaint( e->win->handle(), ready->handle(), update);
      _ps = ready;
   } else {
      _ps = new JBPSpace( WinBeginPaint( e->win->handle(), 0, update));
      needToZap = true;
   }
}

void JPaintEvent::end()
{
   BOOL rc = WinEndPaint( _ps->handle());

   if( needToZap)
      delete _ps;

   if( !rc)
      pmError( 1, "WinEndPaint");
}

// Handler --------------------------------------------------------------------
JPaintHandler::JPaintHandler( BOOL a) : JHandler(), avto( a), cachedPS( 0)
{}

BOOL JPaintHandler::handle( JEventData *e)
{
   if( e->msg == WM_PAINT) {
      JPaintEvent event( e);
      if( avto) {
         event.begin( cachedPS);
      }
      BOOL rc = paint( event);
      if( avto)
         event.end();
      return rc;
   }
   else return false;
}

JPaintHandler &JPaintHandler::setPS( JBPSpace *newps)
{
   cachedPS = newps;
   return self;
}
