/*
 * JPointer.cpp
 *
 * Pointer class - things to do with the mouse
 *                 ( a Pointer is the thing you see when you move the mouse)
 * _________________________________________________________________________
 *
 *                     Part of JLib -  John Fairhurst
 * _________________________________________________________________________
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JWindow.hpp"
#include "JPointer.hpp"
#include "JCoord.hpp"
#include "JIcon.hpp"

JPoint JPointer::pos( void)
{
   JPoint pos;
   BOOL rc = WinQueryPointerPos( JWindow::theDesktopWindow, pos);
   if( !rc)
      pmError( 2, "WinQueryPointerPos");
   return pos;
}

void JPointer::moveto( const JPoint &to)
{
   if( !WinSetPointerPos( JWindow::theDesktopWindow, to.x, to.y))
      pmError( 3, "WinSetPointerPos");
}

void JPointer::show( BOOL show)
{
   WinShowPointer( JWindow::theDesktopWindow, show);
}

void JPointer::hide( void)
{
   WinSetPointer( JWindow::theDesktopWindow, NULLHANDLE);
}

void JPointer::set( JIcon &icon)
{
   BOOL rc = WinSetPointer( JWindow::theDesktopWindow, icon);
   if( !rc) pmError( 3, "WinSetPointer");
}

JIcon JPointer::current( void)
{
   return JIcon( WinQueryPointer( JWindow::theDesktopWindow));
}
