/*
 * JPosnH.cpp
 *
 * Window position change notifications
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "JOs2.h"
#include "JPosnH.hpp"

BOOL JPositionHandler::handle( JEventData *e)
{
   BOOL rc = false;

   switch( e->msg) {
      case WM_ADJUSTWINDOWPOS:
      {
         JPrePositionEvent ev( e);
         rc = preReposition( ev);
         break;
      }
      case WM_WINDOWPOSCHANGED:
      {
         JPostPositionEvent ev( e);
         rc = postReposition( ev);
         break;
      }
   }

   return rc;
}
