/*
 * JPushBut.cpp
 *
 * Base pushbutton control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JPushBut.hpp"
#include "JButton.hpp"
#include "JCoord.hpp"

#define buttErr( s) jlib_throw( new JException( err_button, JExn::base, s))

JPushButton::JPushButton( JWindow *parent, const JPoint &pos,
                          const JSize &size, ulong id, ulong style,
                          const char *text)
            : JButton( parent, text, style | BS_PUSHBUTTON, pos, size, id)
{}

const unsigned long JPushButton::defButton  = BS_DEFAULT;
const unsigned long JPushButton::help       = BS_HELP;
const unsigned long JPushButton::syscommand = BS_SYSCOMMAND;
const unsigned long JPushButton::normal     = 0;

JPushButton &JPushButton::setDefault( BOOL set)
{
   BOOL rc = sendEvent( BM_SETDEFAULT, set);
   if( !rc)
      buttErr( "setting a default");

   return self;
}

BOOL JPushButton::isDefault() const
{
   ulong papa = parent()->handle();
   return ID() == WinQueryWindowULong( papa, QWL_DEFBUTTON);
}

JPushButton &JPushButton::setHilight( BOOL on)
{
   sendEvent( BM_SETHILITE, on);
   return self;
}

BOOL JPushButton::hasHilight() const
{
   return sendEvent( BM_QUERYHILITE);
}
