/*
 * JScrllbar.cpp
 *
 * Scrollbar control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JScrlbar.hpp"
#include "JMParam.hpp"
#include "JIntern.hpp"

#define scrllError( s) jlib_throw( new JException( err_scrollbar, JExn::base, s))

const ulong JScrollbar::vertical   = SBS_VERT;
const ulong JScrollbar::horizontal = SBS_HORZ;
const ulong JScrollbar::dynamic    = SBS_AUTOTRACK;

JScrollbar::JScrollbar( JWindow *w, const JPoint &pos, const JSize &size,
                        ulong Id, ulong style)
{
   assertParms( w, "JScrollbar::JScrollbar");
   assertParms( !((style & vertical) && (style & horizontal)),
                "JScrollbar::JScrollbar");

   JCreateWBlock b( w->handle(), WC_SCROLLBAR, 0,
                    JWindow::visible | SBS_THUMBSIZE | style,
                    pos, size, w->handle(), HWND_TOP, Id, 0, 0);

   setHwnd( JInternal::window::create( &b));
}

JScrollbar &JScrollbar::setRange( const JRange &r, short pos)
{
   BOOL rc = sendEvent( SBM_SETSCROLLBAR, pos, JMP( r.low, r.high));
   if( !rc)
      scrllError( "set the scrollbar");
   return self;
}

JScrollbar &JScrollbar::setSliderSize( short total, short visible)
{
   BOOL rc = sendEvent( SBM_SETTHUMBSIZE, JMP( visible, total));
   if( !rc)
      scrllError( "set the thumb-size");
   return self;
}

JScrollbar &JScrollbar::moveSliderTo( short where)
{
   BOOL rc = sendEvent( SBM_SETPOS, where);
   if( !rc)
      scrllError( "set the slider position");
   return self;
}

JScrollbar &JScrollbar::incrementSlider()
{
   return moveSliderTo( position() + 1);
}

JScrollbar &JScrollbar::decrementSlider()
{
   return moveSliderTo( position() - 1);
}

JRange JScrollbar::range() const
{
   JMP rc = sendEvent( SBM_QUERYRANGE);
   JRange rnge( rc.s1(), rc.s2());
   return rnge;
}

short JScrollbar::position() const
{
   return sendEvent( SBM_QUERYPOS);
}
