/*
 * JScrollH.cpp
 *
 * Scroll event & handler
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JScrollH.hpp"

// Handler --------------------------------------------------------------------
BOOL JScrollHandler::handle( JEventData *e)
{
   if( e->mp1 != Id || (e->msg != WM_HSCROLL && e->msg != WM_VSCROLL))
      return false;

   switch( e->mp2.s2()) {
      case SB_ENDSCROLL:
         return true;
      case SB_SLIDERTRACK:
         return tracking( JScrollEvent( e));
      case SB_SLIDERPOSITION:
         return dragEnded( JScrollEvent( e));
      case SB_LINEUP:
      case SB_LINEDOWN:
//    case SB_LINELEFT  == SB_LINEUP
//    case SB_LINERIGHT == SB_LINEDOWN
         return lineScroll( JScrollEvent( e));
      default:
         return pageScroll( JScrollEvent( e));
   }
}
