/*
 * JSelButt.cpp
 *
 * Selectable buttons - radios and checkboxes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JSelButt.hpp"
#include "JCoord.hpp"
#include "JButton.hpp"

#define buttErr( s) jlib_throw( new JException( err_button, JExn::base, s))

// radio
JRadioButton::JRadioButton( JWindow *parent, const JPoint &pos,
                            const JSize &size, ulong id, ulong style,
                            const char *text)
             : JButton( parent, text, style | BS_AUTORADIOBUTTON, pos, size, id)
{}

const unsigned long JRadioButton::noselect = BS_NOCURSORSELECT;
const unsigned long JRadioButton::nofocus  = BS_NOPOINTERFOCUS;
const unsigned long JRadioButton::normal = 0;

JRadioButton &JRadioButton::check( BOOL set)
{
   sendEvent( BM_SETCHECK, set);
   return self;
}

BOOL JRadioButton::isChecked() const
{
   return sendEvent( BM_QUERYCHECK);
}

int JRadioButton::getChecked() const
{
   int rc = sendEvent( BM_QUERYCHECKINDEX);
   if( rc == -1)
      notFound( "checked button");
   return rc;
}

// checkbox
JCheckBox::JCheckBox( JWindow *parent, const JPoint &pos,
                      const JSize &size, ulong id, ulong style,
                      const char *text)
          : JButton( parent, text, style | BS_AUTOCHECKBOX, pos, size, id)
{}

const unsigned long JCheckBox::noselect = BS_NOCURSORSELECT;
const unsigned long JCheckBox::nofocus  = BS_NOPOINTERFOCUS;
const unsigned long JCheckBox::normal = 0;

JCheckBox &JCheckBox::check( BOOL set)
{
   sendEvent( BM_SETCHECK, set);
   return self;
}

BOOL JCheckBox::isChecked() const
{
   return sendEvent( BM_QUERYCHECK);
}
