/*
 * JShared.cpp
 *
 * Shared memory class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err

#include "JOS2.h"
#include "JShared.hpp"
#include "JStr.hpp"

// Get or allocate a named shared memory object
void *JSharedMem::operator new( size_t s, const char *name)
{
   void *answer; ulong rc;
   JVStr  mname( "\\SHAREMEM\\%s", name);

   // First try to open it
   rc = DosGetNamedSharedMem( &answer, mname.buffer(),
                              PAG_READ | PAG_WRITE | PAG_EXECUTE);

   // assume failure => doesn't exist yet
   if( rc) {
      rc = DosAllocSharedMem( &answer, mname.buffer(), s,
                              PAG_COMMIT | PAG_READ | PAG_WRITE | PAG_EXECUTE);
      dosError( rc, "Dos(*)SharedMem");
   }

   return answer;
}

// Get rid of some memory
void JSharedMem::operator delete( void *v)
{
   DosFreeMem( v);
}

BOOL JSharedMem::exists( const char *name)
{
   void *answer;
   ulong rc;
   JVStr  mname( "\\SHAREMEM\\%s", name);

   rc = DosGetNamedSharedMem( &answer, mname.buffer(),
                              PAG_READ | PAG_WRITE | PAG_EXECUTE);
   if( !rc)
      DosFreeMem( answer);

   return !rc;
}
