/*
 * JStatbar.cpp
 *
 * Status bar - static text at bottom of window
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JStatbar.hpp"
#include "JWindow.hpp"
#include "JFrame.hpp"
#include "JSystem.hpp"
#include "JStaticT.hpp"
#include "JSWP.hpp"

const ulong JStatbar::idStatbar = 0x8000; // FID_STATBAR

JStatbar::JStatbar( JFrame *frame)
         : JFrameCtl( JStatbar::idStatbar, JFrameCtl::belowClient)
{
   JSize sz( 0, JSystem::query( JSystem::menuHeight));
   ctl = new JStaticText( frame, JPoint( 0, 0), sz, JStatbar::idStatbar,
                          JStaticText::vcenter | JWindow::clipSiblings);
}

JStaticText *JStatbar::window() const
{
   return (JStaticText *) ctl;
}
