/*
 * JStaticG.cpp
 *
 * Static graphics controls - bitmaps & icons
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JStaticG.hpp"
#include "JWindow.hpp"
#include "JCoord.hpp"
#include "JStr.hpp"
#include "JIntern.hpp"

#define stError( s) jlib_throw( new JException( err_static, JExn::base, s))

JStaticBitmap::JStaticBitmap( JWindow *parent, const JPoint &position,
                              const JSize &size, ulong ID, ulong resID)
{
   assertParms( parent, "JStaticG::JStaticG");

   JCreateWBlock b( parent->handle(), WC_STATIC, JVStr( "#%u",resID),
                    JWindow::visible | SS_BITMAP, position, size,
                    parent->handle(), HWND_TOP, ID, 0, 0);

   setHwnd( JInternal::window::create( &b));
}

JStaticBitmap &JStaticBitmap::setImage( const JBitmap &nu)
{
   ulong h = sendEvent( SM_SETHANDLE, nu.handle());
   if( !h)
      stError( "set a handle");
   return self;
}

JBitmap JStaticBitmap::getImage()
{
   ulong h = sendEvent( SM_QUERYHANDLE);
   if( !h)
      stError( "query a handle");
   return JBitmap( h);
}

JStaticIcon::JStaticIcon( JWindow *parent, const JPoint &position,
                          const JSize &size, ulong ID, ulong resID)
{
   assertParms( parent, "JStaticG::JStaticG");

   JCreateWBlock b( parent->handle(), WC_STATIC, JVStr( "#%u",resID),
                    JWindow::visible | SS_ICON, position, size,
                    parent->handle(), HWND_TOP, ID, 0, 0);

   setHwnd( JInternal::window::create( &b));
}

JStaticIcon &JStaticIcon::setImage( const JIcon &nu)
{
   ulong h = sendEvent( SM_SETHANDLE, nu.handle());
   if( !h)
      stError( "set a handle");
   return self;
}

JIcon JStaticIcon::getImage()
{
   ulong h = sendEvent( SM_QUERYHANDLE);
   if( !h)
      stError( "query a handle");
   return JIcon( h);
}
